/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CData;
import org.htmlcleaner.CleanTimeValues;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.DoctypeToken;
import org.htmlcleaner.EndTagToken;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.ITagInfoProvider;
import org.htmlcleaner.SpecialEntities;
import org.htmlcleaner.SpecialEntity;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagToken;
import org.htmlcleaner.TagTransformation;
import org.htmlcleaner.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTokenizer {
    private static final int WORKING_BUFFER_SIZE = 1024;
    private BufferedReader _reader;
    private char[] _working = new char[1024];
    private transient int _pos;
    private transient int _len = -1;
    private transient int _row = 1;
    private transient int _col = 1;
    private transient StringBuffer _saved = new StringBuffer(512);
    private transient boolean _isLateForDoctype;
    private transient DoctypeToken _docType;
    private transient TagToken _currentTagToken;
    private transient List<BaseToken> _tokenList = new ArrayList<BaseToken>();
    private transient Set<String> _namespacePrefixes = new HashSet<String>();
    private boolean _asExpected = true;
    private boolean _isSpecialContext;
    private String _isSpecialContextName;
    private HtmlCleaner cleaner;
    private CleanerProperties props;
    private CleanerTransformations transformations;
    private CleanTimeValues cleanTimeValues;

    public HtmlTokenizer(HtmlCleaner cleaner, Reader reader, CleanTimeValues cleanTimeValues) {
        this._reader = new BufferedReader(reader);
        this.cleaner = cleaner;
        this.props = cleaner.getProperties();
        this.transformations = cleaner.getTransformations();
        this.cleanTimeValues = cleanTimeValues;
    }

    private void addToken(BaseToken token) {
        token.setRow(this._row);
        token.setCol(this._col);
        this._tokenList.add(token);
        this.cleaner.makeTree(this._tokenList, this._tokenList.listIterator(this._tokenList.size() - 1), this.cleanTimeValues);
    }

    private void readIfNeeded(int neededChars) throws IOException {
        if (this._len == -1 && this._pos + neededChars >= 1024) {
            int numToCopy = 1024 - this._pos;
            System.arraycopy(this._working, this._pos, this._working, 0, numToCopy);
            this._pos = 0;
            int expected = 1024 - numToCopy;
            int size = 0;
            int charsRead = 0;
            int offset = numToCopy;
            do {
                if ((charsRead = this._reader.read(this._working, offset, expected)) < 0) continue;
                size += charsRead;
                offset += charsRead;
                expected -= charsRead;
            } while (charsRead >= 0 && expected > 0);
            if (expected > 0) {
                this._len = size + numToCopy;
            }
            for (int i = 0; i < (this._len >= 0 ? this._len : 1024); ++i) {
                char ch = this._working[i];
                if (ch >= '\u0001' && ch <= ' ' && ch != '\n' && ch != '\r') {
                    this._working[i] = 32;
                }
                if (ch != '\u0000') continue;
                this._working[i] = 65533;
            }
        }
    }

    List<BaseToken> getTokenList() {
        return this._tokenList;
    }

    Set<String> getNamespacePrefixes() {
        return this._namespacePrefixes;
    }

    private void go() throws IOException {
        this.go(1);
    }

    private void go(int step) throws IOException {
        this._pos += step;
        this.readIfNeeded(step - 1);
    }

    private boolean startsWith(String value) throws IOException {
        int valueLen = value.length();
        this.readIfNeeded(valueLen);
        if (this._len >= 0 && this._pos + valueLen > this._len) {
            return false;
        }
        for (int i = 0; i < valueLen; ++i) {
            char ch2;
            char ch1 = Character.toLowerCase(value.charAt(i));
            if (ch1 == (ch2 = Character.toLowerCase(this._working[this._pos + i]))) continue;
            return false;
        }
        return true;
    }

    private boolean isWhitespace(int position) {
        if (this._len >= 0 && position >= this._len) {
            return false;
        }
        return Character.isWhitespace(this._working[position]);
    }

    private boolean isWhitespace() {
        return this.isWhitespace(this._pos);
    }

    private boolean isChar(int position, char ch) {
        if (this._len >= 0 && position >= this._len) {
            return false;
        }
        return Character.toLowerCase(ch) == Character.toLowerCase(this._working[position]);
    }

    private boolean isChar(char ch) {
        return this.isChar(this._pos, ch);
    }

    private boolean isIdentifierStartChar(int position) {
        if (this._len >= 0 && position >= this._len) {
            return false;
        }
        char ch = this._working[position];
        return Character.isUnicodeIdentifierStart(ch);
    }

    private boolean isIdentifierStartChar() {
        return this.isIdentifierStartChar(this._pos);
    }

    private boolean isIdentifierChar() {
        if (this._len >= 0 && this._pos >= this._len) {
            return false;
        }
        char ch = this._working[this._pos];
        return Character.isUnicodeIdentifierStart(ch) || Character.isDigit(ch) || Utils.isIdentifierHelperChar(ch);
    }

    private boolean isAllRead() {
        return this._len >= 0 && this._pos >= this._len;
    }

    private void save(char ch) {
        this.updateCoordinates(ch);
        this._saved.append(ch);
    }

    private void updateCoordinates(char ch) {
        if (ch == '\n') {
            ++this._row;
            this._col = 1;
        } else {
            ++this._col;
        }
    }

    private void saveCurrent() {
        if (!this.isAllRead()) {
            this.save(this._working[this._pos]);
        }
    }

    private void saveCurrent(int size) throws IOException {
        this.readIfNeeded(size);
        int pos = this._pos;
        while (!this.isAllRead() && size > 0) {
            this.save(this._working[pos]);
            ++pos;
            --size;
        }
    }

    private void skipWhitespaces() throws IOException {
        while (!this.isAllRead() && this.isWhitespace()) {
            this.saveCurrent();
            this.go();
        }
    }

    private boolean addSavedAsContent() {
        if (this._saved.length() > 0) {
            this.addToken(new ContentNode(this.props.isDeserializeEntities() ? this.deserializeEntitiesInSaved() : this._saved.toString()));
            this._saved.delete(0, this._saved.length());
            return true;
        }
        return false;
    }

    private String deserializeEntitiesInSaved() {
        SpecialEntities entities = SpecialEntities.INSTANCE;
        int entityStart = -1;
        boolean numericEntity = false;
        boolean hexEntity = false;
        int maxEntityLength = entities.getMaxEntityLength();
        int i = 0;
        int length = this._saved.length();
        while (i < length) {
            if (this._saved.charAt(i) == '&') {
                entityStart = i++;
                numericEntity = false;
                hexEntity = false;
                continue;
            }
            if (entityStart != -1) {
                if (this._saved.charAt(i) == ';') {
                    SpecialEntity entity;
                    int entityValue = -1;
                    if (numericEntity) {
                        try {
                            entityValue = Integer.parseInt(this._saved.substring(entityStart + (hexEntity ? 3 : 2), i), hexEntity ? 16 : 10);
                        }
                        catch (NumberFormatException e) {
                            entityValue = -1;
                        }
                        entity = entities.getSpecialEntityByUnicode(entityValue);
                        if (entity != null) {
                            entityValue = entity.intValue();
                        } else if (!this.props.isRecognizeUnicodeChars()) {
                            entityValue = -1;
                        }
                    } else {
                        entity = entities.getSpecialEntity(this._saved.substring(entityStart + 1, i));
                        if (entity != null) {
                            entityValue = entity.intValue();
                        }
                    }
                    if (entityValue >= 0) {
                        char[] decodedEntity = Character.toChars(entityValue);
                        this._saved.replace(entityStart, i + 1, new String(decodedEntity));
                        length = this._saved.length();
                        i = entityStart + decodedEntity.length;
                    } else {
                        ++i;
                    }
                    entityStart = -1;
                    continue;
                }
                if (i == entityStart + 1 && this._saved.charAt(i) == '#') {
                    numericEntity = true;
                } else if (i == entityStart + 2 && numericEntity && this._saved.charAt(i) == 'x') {
                    hexEntity = true;
                } else if (i - entityStart > maxEntityLength) {
                    entityStart = -1;
                }
                ++i;
                continue;
            }
            ++i;
        }
        return this._saved.toString();
    }

    void start() throws IOException {
        this._currentTagToken = null;
        this._tokenList.clear();
        this._asExpected = true;
        this._isSpecialContext = false;
        this._isLateForDoctype = false;
        this._namespacePrefixes.clear();
        this._pos = 1024;
        this.readIfNeeded(0);
        boolean isSpecialEmpty = true;
        while (!this.isAllRead()) {
            if (Thread.currentThread().isInterrupted()) {
                this.handleInterruption();
                this._tokenList.clear();
                this._namespacePrefixes.clear();
                this._reader.close();
                return;
            }
            this._saved.delete(0, this._saved.length());
            this._currentTagToken = null;
            this._asExpected = true;
            this.readIfNeeded(10);
            if (this._isSpecialContext) {
                int nameLen = this._isSpecialContextName.length();
                if (this.startsWith("</" + this._isSpecialContextName) && (this.isWhitespace(this._pos + nameLen + 2) || this.isChar(this._pos + nameLen + 2, '>'))) {
                    this.tagEnd();
                } else if (isSpecialEmpty && this.startsWith("<!--")) {
                    this.comment();
                } else if (this.startsWith("/*<![CDATA[*/") || this.startsWith("<![CDATA[") || this.startsWith("//<![CDATA[")) {
                    this.cdata();
                } else {
                    String lastTokenAsString;
                    BaseToken lastToken;
                    boolean isTokenAdded = this.content();
                    if (isSpecialEmpty && isTokenAdded && (lastToken = this._tokenList.get(this._tokenList.size() - 1)) != null && (lastTokenAsString = lastToken.toString()) != null && lastTokenAsString.trim().length() > 0) {
                        isSpecialEmpty = false;
                    }
                }
                if (this._isSpecialContext) continue;
                isSpecialEmpty = true;
                continue;
            }
            if (this.startsWith("<!doctype")) {
                if (!this._isLateForDoctype) {
                    this.doctype();
                    this._isLateForDoctype = true;
                    continue;
                }
                this.ignoreUntil('<');
                continue;
            }
            if (this.startsWith("</") && this.isIdentifierStartChar(this._pos + 2)) {
                this._isLateForDoctype = true;
                this.tagEnd();
                continue;
            }
            if (this.startsWith("/*<![CDATA[*/") || this.startsWith("<![CDATA[") || this.startsWith("//<![CDATA[")) {
                this.cdata();
                continue;
            }
            if (this.startsWith("<!--")) {
                this.comment();
                continue;
            }
            if (this.startsWith("<") && this.isIdentifierStartChar(this._pos + 1)) {
                this._isLateForDoctype = true;
                this.tagStart();
                continue;
            }
            if (this.props.isIgnoreQuestAndExclam() && (this.startsWith("<!") || this.startsWith("<?"))) {
                this.ignoreUntil('<');
                if (!this.isChar('>')) continue;
                this.go();
                continue;
            }
            if (this.startsWith("<?xml")) {
                this.ignoreUntil('<');
                continue;
            }
            this.content();
        }
        this._reader.close();
    }

    private boolean isReservedTag(String tagName) {
        return "html".equalsIgnoreCase(tagName) || "head".equalsIgnoreCase(tagName) || "body".equalsIgnoreCase(tagName);
    }

    private void tagStart() throws IOException {
        ITagInfoProvider tagInfoProvider;
        TagInfo tagInfo;
        this.saveCurrent();
        this.go();
        if (this.isAllRead()) {
            return;
        }
        String originalTagName = this.identifier();
        String tagName = this.transformations.getTagName(originalTagName);
        if (tagName != null && ((tagInfo = (tagInfoProvider = this.cleaner.getTagInfoProvider()).getTagInfo(tagName)) == null && !this.props.isOmitUnknownTags() && this.props.isTreatUnknownTagsAsContent() && !this.isReservedTag(tagName) && !this.props.isNamespacesAware() || tagInfo != null && tagInfo.isDeprecated() && !this.props.isOmitDeprecatedTags() && this.props.isTreatDeprecatedTagsAsContent())) {
            this.content();
            return;
        }
        TagNode tagNode = new TagNode(tagName);
        tagNode.setTrimAttributeValues(this.props.isTrimAttributeValues());
        this._currentTagToken = tagNode;
        if (this._asExpected) {
            this.skipWhitespaces();
            this.tagAttributes();
            if (tagName != null) {
                if (this.transformations != null) {
                    tagNode.setAttributes(this.transformations.transformAttributes(originalTagName, tagNode.getAttributesInLowerCase()));
                }
                this.addToken(this._currentTagToken);
            }
            if (this.isChar('>')) {
                this.go();
                if (this.props.isUseCdataFor(tagName)) {
                    this._isSpecialContext = true;
                    this._isSpecialContextName = tagName;
                }
            } else if (this.startsWith("/>")) {
                this.go(2);
                this.addToken(new EndTagToken(tagName));
            }
            this._currentTagToken = null;
        } else {
            this.addSavedAsContent();
        }
    }

    private void tagEnd() throws IOException {
        ITagInfoProvider tagInfoProvider;
        TagInfo tagInfo;
        TagTransformation tagTransformation;
        this.saveCurrent(2);
        this.go(2);
        this._col += 2;
        if (this.isAllRead()) {
            return;
        }
        String tagName = this.identifier();
        if (this.transformations != null && this.transformations.hasTransformationForTag(tagName) && (tagTransformation = this.transformations.getTransformation(tagName)) != null) {
            tagName = tagTransformation.getDestTag();
        }
        if (tagName != null && ((tagInfo = (tagInfoProvider = this.cleaner.getTagInfoProvider()).getTagInfo(tagName)) == null && !this.props.isOmitUnknownTags() && this.props.isTreatUnknownTagsAsContent() && !this.isReservedTag(tagName) && !this.props.isNamespacesAware() || tagInfo != null && tagInfo.isDeprecated() && !this.props.isOmitDeprecatedTags() && this.props.isTreatDeprecatedTagsAsContent())) {
            this.content();
            return;
        }
        this._currentTagToken = new EndTagToken(tagName);
        if (this._asExpected) {
            this.skipWhitespaces();
            this.tagAttributes();
            if (tagName != null) {
                this.addToken(this._currentTagToken);
            }
            if (this.isChar('>')) {
                this.go();
            }
            if (this.props.isUseCdataFor(tagName)) {
                this._isSpecialContext = false;
                this._isSpecialContextName = tagName;
            }
            if (tagName != null && tagName.equalsIgnoreCase("html")) {
                this.skipWhitespaces();
            }
            this._currentTagToken = null;
        } else {
            this.addSavedAsContent();
        }
    }

    private String identifier() throws IOException {
        this._asExpected = true;
        if (!this.isIdentifierStartChar()) {
            this._asExpected = false;
            return null;
        }
        StringBuffer identifierValue = new StringBuffer();
        while (!this.isAllRead() && this.isIdentifierChar()) {
            this.saveCurrent();
            identifierValue.append(this._working[this._pos]);
            this.go();
        }
        while (identifierValue.length() > 0 && Utils.isIdentifierHelperChar(identifierValue.charAt(identifierValue.length() - 1))) {
            identifierValue.deleteCharAt(identifierValue.length() - 1);
        }
        if (identifierValue.length() == 0) {
            return null;
        }
        String id = identifierValue.toString();
        int columnIndex = id.indexOf(58);
        if (columnIndex >= 0) {
            String prefix = id.substring(0, columnIndex);
            String suffix = id.substring(columnIndex + 1);
            int nextColumnIndex = suffix.indexOf(58);
            if (nextColumnIndex >= 0) {
                suffix = suffix.substring(0, nextColumnIndex);
            }
            if (this.props.isNamespacesAware()) {
                id = prefix + ":" + suffix;
                if (!"xmlns".equalsIgnoreCase(prefix)) {
                    this._namespacePrefixes.add(prefix.toLowerCase());
                }
            } else {
                id = suffix;
            }
        }
        return id;
    }

    private void tagAttributes() throws IOException {
        while (!this.isAllRead() && this._asExpected && !this.isChar('>') && !this.startsWith("/>")) {
            String attValue;
            if (Thread.currentThread().isInterrupted()) {
                this.handleInterruption();
                return;
            }
            this.skipWhitespaces();
            String attName = this.identifier();
            if (!this._asExpected) {
                if (!(this.isChar('<') || this.isChar('>') || this.startsWith("/>"))) {
                    this.saveCurrent();
                    this.go();
                }
                if (this.isChar('<')) continue;
                this._asExpected = true;
                continue;
            }
            this.skipWhitespaces();
            if (this.isChar('=')) {
                this.saveCurrent();
                this.go();
                attValue = this.attributeValue();
            } else {
                attValue = "empty".equals(this.props.getBooleanAttributeValues()) ? "" : ("true".equals(this.props.getBooleanAttributeValues()) ? "true" : attName);
            }
            if (!this._asExpected) continue;
            this._currentTagToken.addAttribute(attName, attValue);
        }
    }

    private String attributeValue() throws IOException {
        this.skipWhitespaces();
        if (this.isChar('<') || this.isChar('>') || this.startsWith("/>")) {
            return "";
        }
        boolean isQuoteMode = false;
        boolean isAposMode = false;
        StringBuffer result = new StringBuffer();
        if (this.isChar('\'')) {
            isAposMode = true;
            this.saveCurrent();
            this.go();
        } else if (this.isChar('\"')) {
            isQuoteMode = true;
            this.saveCurrent();
            this.go();
        }
        boolean isMultiWord = this.props.isAllowMultiWordAttributes();
        boolean allowHtml = this.props.isAllowHtmlInsideAttributes();
        while (!(this.isAllRead() || (!isAposMode || this.isChar('\'') || !allowHtml && (this.isChar('>') || this.isChar('<')) || !isMultiWord && this.isWhitespace()) && (!isQuoteMode || this.isChar('\"') || !allowHtml && (this.isChar('>') || this.isChar('<')) || !isMultiWord && this.isWhitespace()) && (isAposMode || isQuoteMode || this.isWhitespace() || this.isChar('>') || this.isChar('<')))) {
            result.append(this._working[this._pos]);
            this.saveCurrent();
            this.go();
        }
        if (this.isChar('\'') && isAposMode) {
            this.saveCurrent();
            this.go();
        } else if (this.isChar('\"') && isQuoteMode) {
            this.saveCurrent();
            this.go();
        }
        return result.toString();
    }

    private boolean content() throws IOException {
        while (!this.isAllRead()) {
            this.saveCurrent();
            this.go();
            if (!this.startsWith("/*<![CDATA[*/") && !this.startsWith("<![CDATA[") && !this.startsWith("//<![CDATA[") && !this.isTagStartOrEnd()) continue;
            break;
        }
        return this.addSavedAsContent();
    }

    private boolean isTagStartOrEnd() throws IOException {
        return this.startsWith("</") || this.startsWith("<!") || this.startsWith("<?") || this.startsWith("<") && this.isIdentifierStartChar(this._pos + 1);
    }

    private void ignoreUntil(char ch) throws IOException {
        while (!this.isAllRead()) {
            this.go();
            this.updateCoordinates(this._working[this._pos]);
            if (!this.isChar(ch)) continue;
            break;
        }
    }

    private void comment() throws IOException {
        this.go(4);
        while (!this.isAllRead() && !this.startsWith("-->")) {
            this.saveCurrent();
            this.go();
        }
        if (this.startsWith("-->")) {
            this.go(3);
        }
        if (this._saved.length() > 0) {
            if (!this.props.isOmitComments()) {
                int len;
                String hyphenRepl = this.props.getHyphenReplacementInComment();
                String comment = this._saved.toString().replaceAll("--", hyphenRepl + hyphenRepl);
                if (comment.length() > 0 && comment.charAt(0) == '-') {
                    comment = hyphenRepl + comment.substring(1);
                }
                if ((len = comment.length()) > 0 && comment.charAt(len - 1) == '-') {
                    comment = comment.substring(0, len - 1) + hyphenRepl;
                }
                this.addToken(new CommentNode(comment));
            }
            this._saved.delete(0, this._saved.length());
        }
    }

    private void cdata() throws IOException {
        if (!this._isSpecialContext && !this.props.isOmitCdataOutsideScriptAndStyle()) {
            this.content();
            return;
        }
        if (this.startsWith("/*<![CDATA[*/")) {
            this.go("/*<![CDATA[*/".length());
        } else if (this.startsWith("//<![CDATA[")) {
            this.go("//<![CDATA[".length());
        } else {
            this.go("<![CDATA[".length());
        }
        int cdataStart = this._saved.length();
        while (!(this.isAllRead() || this.startsWith("/*]]>*/") || this.startsWith("]]>") || this.startsWith("//]]>"))) {
            this.saveCurrent();
            this.go();
        }
        if (this.startsWith("/*]]>*/")) {
            this.go("/*]]>*/".length());
        } else if (this.startsWith("//]]>")) {
            this.go("//]]>".length());
        } else if (this.startsWith("]]>")) {
            this.go("]]>".length());
        }
        if (this._saved.length() > 0 && (this._isSpecialContext || !this.props.isOmitCdataOutsideScriptAndStyle())) {
            String cdata = this._saved.toString().substring(cdataStart);
            this.addToken(new CData(cdata));
        }
        this._saved.delete(cdataStart, this._saved.length());
    }

    private void doctype() throws IOException {
        this.go(9);
        this.skipWhitespaces();
        String part1 = this.identifier();
        this.skipWhitespaces();
        String part2 = this.identifier();
        this.skipWhitespaces();
        String part3 = this.attributeValue();
        this.skipWhitespaces();
        String part4 = this.attributeValue();
        this.skipWhitespaces();
        String part5 = this.attributeValue();
        this.ignoreUntil('<');
        this._docType = part5 == null || part5.length() == 0 ? new DoctypeToken(part1, part2, part3, part4) : new DoctypeToken(part1, part2, part3, part4, part5);
    }

    public DoctypeToken getDocType() {
        return this._docType;
    }

    private void handleInterruption() {
    }
}

