/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.Serializer;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;

public abstract class HtmlSerializer
extends Serializer {
    protected HtmlSerializer(CleanerProperties props) {
        super(props);
    }

    protected boolean isMinimizedTagSyntax(TagNode tagNode) {
        TagInfo tagInfo = this.props.getTagInfoProvider().getTagInfo(tagNode.getName());
        return tagInfo != null && !tagNode.hasChildren() && tagInfo.isEmptyTag();
    }

    protected boolean dontEscape(TagNode tagNode) {
        return this.isScriptOrStyle(tagNode);
    }

    protected String escapeText(String content) {
        return Utils.escapeHtml(content, this.props);
    }

    protected void serializeOpenTag(TagNode tagNode, Writer writer, boolean newLine) throws IOException {
        Map<String, String> nsDeclarations;
        String tagName = tagNode.getName();
        if (Utils.isEmptyString(tagName)) {
            return;
        }
        boolean nsAware = this.props.isNamespacesAware();
        if (!nsAware && Utils.getXmlNSPrefix(tagName) != null) {
            tagName = Utils.getXmlName(tagName);
        }
        writer.write("<" + tagName);
        for (Map.Entry<String, String> entry : tagNode.getAttributes().entrySet()) {
            String attName = entry.getKey();
            if (!nsAware && Utils.getXmlNSPrefix(attName) != null) {
                attName = Utils.getXmlName(attName);
            }
            if (nsAware && attName.equalsIgnoreCase("xmlns")) continue;
            writer.write(" " + attName + "=\"" + this.escapeText(entry.getValue()) + "\"");
        }
        if (nsAware && (nsDeclarations = tagNode.getNamespaceDeclarations()) != null) {
            for (Map.Entry<String, String> entry : nsDeclarations.entrySet()) {
                String prefix = entry.getKey();
                String att = "xmlns";
                if (prefix.length() > 0) {
                    att = att + ":" + prefix;
                }
                writer.write(" " + att + "=\"" + this.escapeText(entry.getValue()) + "\"");
            }
        }
        if (this.isMinimizedTagSyntax(tagNode)) {
            writer.write(" />");
            if (newLine) {
                writer.write("\n");
            }
        } else {
            writer.write(">");
        }
    }

    protected void serializeEndTag(TagNode tagNode, Writer writer, boolean newLine) throws IOException {
        String tagName = tagNode.getName();
        if (Utils.isEmptyString(tagName)) {
            return;
        }
        if (Utils.getXmlNSPrefix(tagName) != null && !this.props.isNamespacesAware()) {
            tagName = Utils.getXmlName(tagName);
        }
        writer.write("</" + tagName + ">");
        if (newLine) {
            writer.write("\n");
        }
    }
}

