/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CData;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomSerializer {
    protected CleanerProperties props;
    protected boolean escapeXml = true;

    public DomSerializer(CleanerProperties props, boolean escapeXml) {
        this.props = props;
        this.escapeXml = escapeXml;
    }

    public DomSerializer(CleanerProperties props) {
        this(props, true);
    }

    public Document createDOM(TagNode rootNode) throws ParserConfigurationException {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation impl = builder.getDOMImplementation();
        if (rootNode.getDocType() != null) {
            String qualifiedName = rootNode.getDocType().getPart1();
            String publicId = rootNode.getDocType().getPublicId();
            String systemId = rootNode.getDocType().getSystemId();
            if (qualifiedName == null) {
                qualifiedName = "html";
            }
            DocumentType documentType = impl.createDocumentType(qualifiedName, publicId, systemId);
            if (qualifiedName.equals("HTML")) {
                qualifiedName = "html";
            }
            document = impl.createDocument(rootNode.getNamespaceURIOnPath(""), qualifiedName, documentType);
        } else {
            document = builder.newDocument();
            Element rootElement = document.createElement(rootNode.getName());
            document.appendChild(rootElement);
        }
        Map<String, String> attributes = rootNode.getAttributes();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attrName = entry.getKey();
            String attrValue = entry.getValue();
            if (this.escapeXml) {
                attrValue = Utils.escapeXml(attrValue, this.props, true);
            }
            document.getDocumentElement().setAttribute(attrName, attrValue);
            if (!attrName.equalsIgnoreCase("id")) continue;
            document.getDocumentElement().setIdAttribute(attrName, true);
        }
        this.createSubnodes(document, document.getDocumentElement(), rootNode.getAllChildren());
        return document;
    }

    protected boolean isScriptOrStyle(Element element) {
        String tagName = element.getNodeName();
        return "script".equalsIgnoreCase(tagName) || "style".equalsIgnoreCase(tagName);
    }

    protected boolean dontEscape(Element element) {
        return this.props.isUseCdataFor(element.getNodeName()) && (!element.hasChildNodes() || element.getTextContent() == null || element.getTextContent().trim().length() == 0);
    }

    protected String outputCData(CData cdata) {
        return cdata.getContentWithoutStartAndEndTokens();
    }

    private void createSubnodes(Document document, Element element, List<? extends BaseToken> tagChildren) {
        if (tagChildren != null) {
            for (BaseToken baseToken : tagChildren) {
                if (baseToken instanceof CommentNode) {
                    CommentNode commentNode = (CommentNode)baseToken;
                    Comment comment = document.createComment(commentNode.getContent());
                    element.appendChild(comment);
                    continue;
                }
                if (baseToken instanceof CData) {
                    if (!this.props.isUseCdataFor(element.getNodeName())) continue;
                    element.appendChild(document.createCDATASection(this.outputCData((CData)baseToken)));
                    continue;
                }
                if (baseToken instanceof ContentNode) {
                    ContentNode contentNode = (ContentNode)baseToken;
                    String content = contentNode.getContent();
                    boolean specialCase = this.dontEscape(element);
                    if (this.escapeXml && !specialCase) {
                        content = Utils.escapeXml(content, this.props, true);
                    }
                    element.appendChild(specialCase ? document.createCDATASection(content) : document.createTextNode(content));
                    continue;
                }
                if (baseToken instanceof TagNode) {
                    TagNode subTagNode = (TagNode)baseToken;
                    Element subelement = document.createElement(subTagNode.getName());
                    Map<String, String> attributes = subTagNode.getAttributes();
                    for (Map.Entry<String, String> entry : attributes.entrySet()) {
                        String attrName = entry.getKey();
                        String attrValue = entry.getValue();
                        if (this.escapeXml) {
                            attrValue = Utils.escapeXml(attrValue, this.props, true);
                        }
                        subelement.setAttribute(attrName, attrValue);
                        if (!attrName.equalsIgnoreCase("id")) continue;
                        subelement.setIdAttribute(attrName, true);
                    }
                    this.createSubnodes(document, subelement, subTagNode.getAllChildren());
                    element.appendChild(subelement);
                    continue;
                }
                if (!(baseToken instanceof List)) continue;
                List sublist = (List)((Object)baseToken);
                this.createSubnodes(document, element, sublist);
            }
        }
    }
}

