/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNaryIndividualAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPairwiseVisitor;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLIndividualAxiomImplWithoutEntityAndAnonCaching;

public abstract class OWLNaryIndividualAxiomImpl
extends OWLIndividualAxiomImplWithoutEntityAndAnonCaching
implements OWLNaryIndividualAxiom {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final List<OWLIndividual> individuals;

    public OWLNaryIndividualAxiomImpl(@Nonnull Set<? extends OWLIndividual> individuals, @Nonnull Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        OWLAPIPreconditions.checkNotNull(individuals, "individuals cannot be null");
        this.individuals = CollectionFactory.sortOptionally(individuals);
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        for (OWLIndividual individual : this.individuals) {
            if (!individual.isNamed()) continue;
            entities.add(individual.asOWLNamedIndividual());
        }
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        for (OWLIndividual individual : this.individuals) {
            if (!individual.isAnonymous()) continue;
            anons.add(individual.asOWLAnonymousIndividual());
        }
    }

    @Override
    public Set<OWLIndividual> getIndividuals() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.individuals);
    }

    @Override
    public List<OWLIndividual> getIndividualsAsList() {
        return new ArrayList<OWLIndividual>(this.individuals);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLNaryIndividualAxiom)) {
            return false;
        }
        if (obj instanceof OWLNaryIndividualAxiomImpl) {
            return this.individuals.equals(((OWLNaryIndividualAxiomImpl)obj).individuals);
        }
        return this.compareObjectOfSameType((OWLNaryIndividualAxiom)obj) == 0;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return OWLNaryIndividualAxiomImpl.compareSets(this.individuals, ((OWLNaryIndividualAxiom)object).getIndividuals());
    }

    @Override
    public <T> Collection<T> walkPairwise(OWLPairwiseVisitor<T, OWLIndividual> visitor) {
        ArrayList<T> l = new ArrayList<T>();
        for (int i = 0; i < this.individuals.size() - 1; ++i) {
            for (int j = i + 1; j < this.individuals.size(); ++j) {
                T t = visitor.visit(this.individuals.get(i), this.individuals.get(j));
                if (t == null) continue;
                l.add(t);
            }
        }
        return l;
    }
}

