/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLCardinalityRestrictionImpl;

public abstract class OWLDataCardinalityRestrictionImpl
extends OWLCardinalityRestrictionImpl<OWLDataRange>
implements OWLDataCardinalityRestriction {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLDataPropertyExpression property;

    protected OWLDataCardinalityRestrictionImpl(@Nonnull OWLDataPropertyExpression property, int cardinality, @Nonnull OWLDataRange filler) {
        super(cardinality, filler);
        this.property = OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        OWLDataRange filler = (OWLDataRange)this.getFiller();
        this.addSignatureEntitiesToSetForValue(entities, filler);
        this.addSignatureEntitiesToSetForValue(entities, this.property);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        OWLDataRange filler = (OWLDataRange)this.getFiller();
        this.addAnonymousIndividualsToSetForValue(anons, filler);
    }

    @Override
    public OWLDataPropertyExpression getProperty() {
        return this.property;
    }

    @Override
    public boolean isQualified() {
        return !((OWLDataRange)this.getFiller()).isTopDatatype();
    }

    @Override
    public boolean isObjectRestriction() {
        return false;
    }

    @Override
    public boolean isDataRestriction() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLDataCardinalityRestriction)) {
            return false;
        }
        return this.getProperty().equals(((OWLDataCardinalityRestriction)obj).getProperty());
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLDataCardinalityRestriction other = (OWLDataCardinalityRestriction)object;
        int diff = this.getProperty().compareTo(other.getProperty());
        if (diff != 0) {
            return diff;
        }
        diff = this.getCardinality() - other.getCardinality();
        if (diff != 0) {
            return diff;
        }
        return ((OWLDataRange)this.getFiller()).compareTo(other.getFiller());
    }
}

