/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.rdf.rdfxml.parser.Translators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OptimisedListTranslator<O extends OWLObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptimisedListTranslator.class);
    private final OWLRDFConsumer consumer;
    private final Translators.ListItemTranslator<O> translator;

    protected OptimisedListTranslator(OWLRDFConsumer consumer, Translators.ListItemTranslator<O> translator) {
        this.consumer = consumer;
        this.translator = translator;
    }

    protected OWLRDFConsumer getConsumer() {
        return this.consumer;
    }

    private void translateList(IRI mainNode, @Nonnull List<O> list) {
        IRI current = mainNode;
        while (current != null) {
            IRI firstResource = this.consumer.getFirstResource(current, true);
            if (firstResource != null) {
                O translate = this.translator.translate(firstResource);
                if (translate != null) {
                    LOGGER.debug("list: {}", translate);
                    list.add(translate);
                } else {
                    LOGGER.warn("Possible malformed list: cannot translate it {}", (Object)firstResource);
                }
            } else {
                OWLLiteral literal = this.consumer.getFirstLiteral(current);
                if (literal != null) {
                    O translate = this.translator.translate(literal);
                    if (translate != null) {
                        list.add(translate);
                    }
                } else {
                    LOGGER.warn("Possible malformed list: rdf:first triple missing");
                }
            }
            current = this.consumer.getRest(current, true);
        }
    }

    @Nonnull
    public List<O> translateList(@Nonnull IRI mainNode) {
        List list;
        boolean shared = this.consumer.isAnonymousSharedNode(mainNode.toString());
        if (shared) {
            Object o = this.consumer.getSharedAnonymousNode(mainNode);
            if (o != null && o instanceof List) {
                list = (List)o;
            } else {
                list = new ArrayList();
                this.translateList(mainNode, list);
                this.consumer.addSharedAnonymousNode(mainNode, list);
            }
        } else {
            list = new ArrayList();
            this.translateList(mainNode, list);
        }
        return list;
    }

    @Nonnull
    public Set<O> translateToSet(@Nonnull IRI mainNode) {
        return new LinkedHashSet<O>(this.translateList(mainNode));
    }
}

