/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;

public class IdTranslator {
    @Nonnull
    static final String OBO_IRI_PREFIX = "http://purl.obolibrary.org/obo/";
    @Nonnull
    private final Map<String, String> idspaceMap = new HashMap<String, String>();

    @Nullable
    public static String translateIRI(IRI iri) {
        return null;
    }

    @Nullable
    public String translateIdToIRIString(@Nonnull String id) {
        if (IdTranslator.isURI(id)) {
            return id;
        }
        if (id.contains(":")) {
            int p = id.lastIndexOf(58);
            String prefix = id.substring(0, p);
            String localId = id.substring(p + 1);
            if (!localId.isEmpty() && localId.replaceAll("[0-9]", "").isEmpty()) {
                return this.expandPrefix(prefix) + localId;
            }
        }
        return null;
    }

    public static boolean isURI(@Nonnull String id) {
        return id.startsWith("http:") || id.startsWith("ftp:") || id.startsWith("https:");
    }

    public String expandPrefix(String prefix) {
        if (this.idspaceMap.containsKey(prefix)) {
            return this.idspaceMap.get(prefix);
        }
        return OBO_IRI_PREFIX + prefix + '_';
    }
}

