package de.huberlin.ire;

import com.google.gson.annotations.SerializedName;

public class App {

    @SerializedName("app_name")
    private final String title;
    private final String url;
    private final String reviewCount;
    private final String description;

    private final String installations;
    private final String lastUpdate;
    private final String currentVersion;

    public App(String title, String url, String reviewCount, String description,
               String installations, String lastUpdate, String currentVersion) {
        this.title = title;
        this.url = url;
        this.reviewCount = reviewCount;
        this.description = description;
        this.installations = installations;
        this.lastUpdate = lastUpdate;
        this.currentVersion = currentVersion;
    }

    public String getTitle() {
        return title;
    }

    public String getUrl() {
        return url;
    }

    public String getReviewCount() {
        return reviewCount;
    }

    public String getDescription() {
        return description;
    }

    public String getInstallations() {
        return installations;
    }

    public String getLastUpdate() {
        return lastUpdate;
    }

    public String getCurrentVersion() {
        return currentVersion;
    }

    @Override
    public String toString() {
        return "App{" +
            "title='" + title + '\'' +
            ", url='" + url + '\'' +
            ", reviewCount='" + reviewCount + '\'' +
            ", description='" + description + '\'' +
            ", installations='" + installations + '\'' +
            ", lastUpdate='" + lastUpdate + '\'' +
            ", currentVersion='" + currentVersion + '\'' +
            '}';
    }
}

