-- MySQL dump 10.11
--
-- Host: raps    Database: pipa_dev
-- ------------------------------------------------------
-- Server version	5.1.36-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `chromosomal_location`
--

DROP TABLE IF EXISTS `chromosomal_location`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `chromosomal_location` (
  `molecule_id` int(10) unsigned NOT NULL,
  `location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`molecule_id`,`location`),
  CONSTRAINT `chromosomal_location_ibfk_1` FOREIGN KEY (`molecule_id`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `client_properties`
--

DROP TABLE IF EXISTS `client_properties`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `client_properties` (
  `property_key` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `property_value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`property_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `complex`
--

DROP TABLE IF EXISTS `complex`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `complex` (
  `molecule_id` int(10) unsigned NOT NULL,
  `complex_part_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`molecule_id`,`complex_part_id`),
  KEY `complex_part_id` (`complex_part_id`),
  CONSTRAINT `complex_ibfk_1` FOREIGN KEY (`molecule_id`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `db_source`
--

DROP TABLE IF EXISTS `db_source`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `db_source` (
  `db_source_id` tinyint(4) unsigned NOT NULL,
  `db_source_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`db_source_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `edge`
--

DROP TABLE IF EXISTS `edge`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `edge` (
  `interaction_id` int(8) unsigned NOT NULL,
  `pathway_id` int(8) unsigned NOT NULL,
  `db_source_id` tinyint(4) unsigned NOT NULL,
  `molecule_id1` int(10) unsigned NOT NULL,
  `molecule_id2` int(10) unsigned NOT NULL,
  UNIQUE KEY `interaction_id` (`interaction_id`,`pathway_id`,`db_source_id`,`molecule_id1`,`molecule_id2`),
  KEY `molecule_id1` (`molecule_id1`),
  KEY `molecule_id2` (`molecule_id2`),
  KEY `db_source_id` (`db_source_id`,`pathway_id`,`interaction_id`),
  CONSTRAINT `edge_ibfk_2` FOREIGN KEY (`molecule_id1`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `edge_ibfk_3` FOREIGN KEY (`molecule_id2`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `edge_ibfk_4` FOREIGN KEY (`db_source_id`, `pathway_id`, `interaction_id`) REFERENCES `interaction` (`db_source_id`, `pathway_id`, `id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `experiment`
--

DROP TABLE IF EXISTS `experiment`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `experiment` (
  `interaction_id` int(11) unsigned NOT NULL,
  `detection_method` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pmid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  UNIQUE KEY `interaction_id_2` (`interaction_id`,`detection_method`),
  UNIQUE KEY `interaction_id` (`interaction_id`,`detection_method`,`pmid`),
  KEY `interaction_id_3` (`interaction_id`),
  CONSTRAINT `experiment_ibfk_1` FOREIGN KEY (`interaction_id`) REFERENCES `protein_interaction` (`interaction_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `gad`
--

DROP TABLE IF EXISTS `gad`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `gad` (
  `gad_id` int(10) unsigned NOT NULL DEFAULT '0',
  `disease_class` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `broad_phenotype` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`gad_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `gad_omim`
--

DROP TABLE IF EXISTS `gad_omim`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `gad_omim` (
  `gad_id` int(10) unsigned NOT NULL DEFAULT '0',
  `omim_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gad_id`,`omim_id`),
  KEY `omim_id` (`omim_id`),
  CONSTRAINT `gad_omim_ibfk_1` FOREIGN KEY (`gad_id`) REFERENCES `gad` (`gad_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `gad_rel`
--

DROP TABLE IF EXISTS `gad_rel`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `gad_rel` (
  `gad_id` int(10) unsigned NOT NULL DEFAULT '0',
  `gene_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `assoc_y` int(10) unsigned NOT NULL DEFAULT '0',
  `assoc_n` int(10) unsigned NOT NULL DEFAULT '0',
  `assoc_x` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gad_id`,`gene_id`,`assoc_y`,`assoc_n`,`assoc_x`),
  KEY `gad_id` (`gad_id`),
  KEY `gene_id` (`gene_id`),
  CONSTRAINT `gad_rel_ibfk_1` FOREIGN KEY (`gad_id`) REFERENCES `gad` (`gad_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `go`
--

DROP TABLE IF EXISTS `go`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `go` (
  `go_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ontology` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `is_obsolete` enum('0','1') COLLATE utf8_unicode_ci DEFAULT NULL,
  `min_depth` int(11) DEFAULT NULL,
  `max_depth` int(11) DEFAULT NULL,
  `avg_depth` double DEFAULT NULL,
  PRIMARY KEY (`go_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `go_alternative_id`
--

DROP TABLE IF EXISTS `go_alternative_id`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `go_alternative_id` (
  `go_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `alternative_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  KEY `go_id` (`go_id`),
  CONSTRAINT `go_alternative_id_ibfk_1` FOREIGN KEY (`go_id`) REFERENCES `go` (`go_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `go_consider`
--

DROP TABLE IF EXISTS `go_consider`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `go_consider` (
  `go_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `consider_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  KEY `go_id` (`go_id`),
  CONSTRAINT `go_consider_ibfk_1` FOREIGN KEY (`go_id`) REFERENCES `go` (`go_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `go_rel`
--

DROP TABLE IF EXISTS `go_rel`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `go_rel` (
  `go_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `molecule_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`go_id`,`molecule_id`),
  KEY `molecule_id` (`molecule_id`),
  CONSTRAINT `go_rel_ibfk_1` FOREIGN KEY (`molecule_id`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `go_rel_evidence`
--

DROP TABLE IF EXISTS `go_rel_evidence`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `go_rel_evidence` (
  `go_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `molecule_id` int(11) unsigned NOT NULL,
  `evidence` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `db_source_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`go_id`,`molecule_id`,`evidence`),
  KEY `go_id` (`go_id`,`molecule_id`),
  KEY `molecule_id` (`molecule_id`),
  CONSTRAINT `go_rel_evidence_ibfk_2` FOREIGN KEY (`molecule_id`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `go_rel_evidence_add`
--

DROP TABLE IF EXISTS `go_rel_evidence_add`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `go_rel_evidence_add` (
  `go_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `molecule_id` int(11) unsigned NOT NULL,
  `evidence` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `source` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`go_id`,`molecule_id`,`evidence`),
  KEY `go_id` (`go_id`,`molecule_id`),
  KEY `molecule_id` (`molecule_id`),
  CONSTRAINT `go_rel_evidence_add_ibfk_1` FOREIGN KEY (`molecule_id`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `go_relationship`
--

DROP TABLE IF EXISTS `go_relationship`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `go_relationship` (
  `go_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent_go_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`go_id`,`parent_go_id`,`type`),
  KEY `parent_go_id` (`parent_go_id`),
  CONSTRAINT `go_relationship_ibfk_1` FOREIGN KEY (`go_id`) REFERENCES `go` (`go_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `go_relationship_ibfk_2` FOREIGN KEY (`parent_go_id`) REFERENCES `go` (`go_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `interaction`
--

DROP TABLE IF EXISTS `interaction`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `interaction` (
  `id` int(8) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `short_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `direction` tinyint(1) NOT NULL,
  `pathway_id` int(8) unsigned NOT NULL,
  `db_source_id` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`db_source_id`,`pathway_id`,`id`),
  KEY `db_source_id` (`db_source_id`,`pathway_id`),
  CONSTRAINT `interaction_ibfk_1` FOREIGN KEY (`db_source_id`, `pathway_id`) REFERENCES `pathway` (`db_source_id`, `id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `interconnection`
--

DROP TABLE IF EXISTS `interconnection`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `interconnection` (
  `pathway_id` int(8) unsigned NOT NULL,
  `db_source_id` tinyint(3) unsigned NOT NULL,
  `connected_pathway_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `intermediate_id` int(8) unsigned NOT NULL DEFAULT '0',
  KEY `intermediate_id` (`intermediate_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `interpro`
--

DROP TABLE IF EXISTS `interpro`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `interpro` (
  `interpro_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`interpro_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `interpro_rel`
--

DROP TABLE IF EXISTS `interpro_rel`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `interpro_rel` (
  `interpro_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `molecule_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`interpro_id`,`molecule_id`),
  KEY `molecule_id` (`molecule_id`),
  CONSTRAINT `interpro_rel_ibfk_1` FOREIGN KEY (`molecule_id`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `kegg_pathway`
--

DROP TABLE IF EXISTS `kegg_pathway`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `kegg_pathway` (
  `pathway_id` char(13) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `class` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`pathway_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `kegg_rel`
--

DROP TABLE IF EXISTS `kegg_rel`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `kegg_rel` (
  `pathway_id` char(13) COLLATE utf8_unicode_ci NOT NULL,
  `kegg_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  KEY `pathway_id` (`pathway_id`),
  CONSTRAINT `kegg_rel_ibfk_1` FOREIGN KEY (`pathway_id`) REFERENCES `kegg_pathway` (`pathway_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `lookup_mapping`
--

DROP TABLE IF EXISTS `lookup_mapping`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `lookup_mapping` (
  `uniprot_id` char(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  `foreign_db` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `foreign_key` varchar(70) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `foreign_key` (`foreign_key`,`foreign_db`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `lookup_organism_taxonomy`
--

DROP TABLE IF EXISTS `lookup_organism_taxonomy`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `lookup_organism_taxonomy` (
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `taxon_id` int(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`name`,`taxon_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `lookup_protein`
--

DROP TABLE IF EXISTS `lookup_protein`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `lookup_protein` (
  `primary_uniprot_id` char(6) COLLATE utf8_unicode_ci NOT NULL,
  `protein_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sequence` mediumtext COLLATE utf8_unicode_ci,
  `species` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gene_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ref_seq` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `org_specific_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `kegg_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ec_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `chrom_location` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `interpro_ids` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `go_ids` mediumtext COLLATE utf8_unicode_ci,
  `reactome_ids` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`primary_uniprot_id`),
  UNIQUE KEY `ref_seq` (`ref_seq`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `lookup_uniprot_accession`
--

DROP TABLE IF EXISTS `lookup_uniprot_accession`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `lookup_uniprot_accession` (
  `id` char(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `lookup_uniprot_demerged`
--

DROP TABLE IF EXISTS `lookup_uniprot_demerged`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `lookup_uniprot_demerged` (
  `old_id` char(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  `new_id` char(6) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `lookup_uniprot_id`
--

DROP TABLE IF EXISTS `lookup_uniprot_id`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `lookup_uniprot_id` (
  `primary_uniprot_id` char(6) COLLATE utf8_unicode_ci NOT NULL,
  `secondary_uniprot_id` char(6) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`primary_uniprot_id`,`secondary_uniprot_id`),
  KEY `primary_uniprot_id` (`primary_uniprot_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `lookup_uniprot_secondary_accession_mapping`
--

DROP TABLE IF EXISTS `lookup_uniprot_secondary_accession_mapping`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `lookup_uniprot_secondary_accession_mapping` (
  `secondary_id` char(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `primary_id` char(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`secondary_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `molecule`
--

DROP TABLE IF EXISTS `molecule`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `molecule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` int(11) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `short_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `primary_uniprot_id` char(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_id` int(11) unsigned DEFAULT NULL,
  `cellular_location` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `primary_uniprot_id` (`primary_uniprot_id`),
  KEY `type_id` (`type_id`),
  CONSTRAINT `molecule_ibfk_1` FOREIGN KEY (`type_id`) REFERENCES `molecule_type` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `molecule_pathway_relation`
--

DROP TABLE IF EXISTS `molecule_pathway_relation`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `molecule_pathway_relation` (
  `molecule_id` int(10) unsigned NOT NULL,
  `pathway_id` int(8) unsigned NOT NULL,
  `db_source_id` tinyint(3) unsigned NOT NULL,
  KEY `db_source_id` (`db_source_id`,`pathway_id`),
  KEY `molecule_id` (`molecule_id`),
  CONSTRAINT `molecule_pathway_relation_ibfk_1` FOREIGN KEY (`molecule_id`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `molecule_pathway_relation_ibfk_2` FOREIGN KEY (`db_source_id`, `pathway_id`) REFERENCES `pathway` (`db_source_id`, `id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `molecule_type`
--

DROP TABLE IF EXISTS `molecule_type`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `molecule_type` (
  `id` int(10) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `omim_disease`
--

DROP TABLE IF EXISTS `omim_disease`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `omim_disease` (
  `omim_id` int(10) unsigned NOT NULL DEFAULT '0',
  `omim_id_prefix` enum('#','+','%','') COLLATE utf8_unicode_ci DEFAULT '',
  `phenotype_description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `omim_id` (`omim_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `omim_disease_type`
--

DROP TABLE IF EXISTS `omim_disease_type`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `omim_disease_type` (
  `omim_id` int(10) unsigned NOT NULL DEFAULT '0',
  `disease_class` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `disease_subtype` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`omim_id`,`disease_class`,`disease_subtype`),
  CONSTRAINT `omim_disease_type_ibfk_1` FOREIGN KEY (`omim_id`) REFERENCES `omim_disease` (`omim_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `omim_locus`
--

DROP TABLE IF EXISTS `omim_locus`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `omim_locus` (
  `omim_id` int(10) unsigned DEFAULT NULL,
  `locus` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `omim_id` (`omim_id`),
  CONSTRAINT `omim_locus_ibfk_2` FOREIGN KEY (`omim_id`) REFERENCES `omim_disease` (`omim_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `omim_rel`
--

DROP TABLE IF EXISTS `omim_rel`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `omim_rel` (
  `omim_id` int(10) unsigned NOT NULL DEFAULT '0',
  `omim_genotype` int(11) unsigned NOT NULL,
  PRIMARY KEY (`omim_id`,`omim_genotype`),
  KEY `omim_genotype` (`omim_genotype`),
  CONSTRAINT `omim_rel_ibfk_1` FOREIGN KEY (`omim_id`) REFERENCES `omim_disease` (`omim_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `organism_taxonomy`
--

DROP TABLE IF EXISTS `organism_taxonomy`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `organism_taxonomy` (
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `taxon_id` int(9) NOT NULL DEFAULT '0',
  UNIQUE KEY `name` (`name`,`taxon_id`),
  KEY `idx` (`taxon_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `pathway`
--

DROP TABLE IF EXISTS `pathway`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `pathway` (
  `id` int(8) unsigned NOT NULL,
  `db_source_id` tinyint(3) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `interconnection_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `short_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `taxon_id` int(9) DEFAULT NULL,
  `last_update` date DEFAULT NULL,
  `ppi` tinyint(1) NOT NULL,
  PRIMARY KEY (`db_source_id`,`id`),
  KEY `taxon_id` (`taxon_id`),
  CONSTRAINT `pathway_ibfk_1` FOREIGN KEY (`db_source_id`) REFERENCES `db_source` (`db_source_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `protein_interaction`
--

DROP TABLE IF EXISTS `protein_interaction`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `protein_interaction` (
  `interaction_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `protein_id_a` int(11) unsigned NOT NULL,
  `protein_id_b` int(11) unsigned NOT NULL,
  `db_source_id` int(11) unsigned NOT NULL,
  `interaction_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `predicted` enum('0','1') COLLATE utf8_unicode_ci DEFAULT NULL,
  `complex_ppi` enum('0','1') COLLATE utf8_unicode_ci DEFAULT NULL,
  `disease_ppi` enum('0','1') COLLATE utf8_unicode_ci DEFAULT NULL,
  `demerged` enum('0','1') COLLATE utf8_unicode_ci DEFAULT NULL,
  `experimental_role_a` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `experimental_role_b` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`interaction_id`),
  KEY `protein_id_a` (`protein_id_a`),
  KEY `protein_id_b` (`protein_id_b`),
  KEY `db_source_id` (`db_source_id`),
  CONSTRAINT `protein_interaction_ibfk_1` FOREIGN KEY (`protein_id_a`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `protein_interaction_ibfk_2` FOREIGN KEY (`protein_id_b`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `protein_interaction_filtered`
--

DROP TABLE IF EXISTS `protein_interaction_filtered`;
/*!50001 DROP VIEW IF EXISTS `protein_interaction_filtered`*/;
/*!50001 CREATE TABLE `protein_interaction_filtered` (
  `id` int(10) unsigned,
  `predicted` enum('0','1'),
  `complex` enum('0','1'),
  `disease` enum('0','1'),
  `demerged` enum('0','1'),
  `from_id` char(6),
  `to_id` char(6),
  `source` varchar(255),
  `experimental_role_a` varchar(255),
  `experimental_role_b` varchar(255),
  `tax_id` int(11) unsigned
) */;

--
-- Table structure for table `reactome`
--

DROP TABLE IF EXISTS `reactome`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `reactome` (
  `reactome_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`reactome_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `reactome_rel`
--

DROP TABLE IF EXISTS `reactome_rel`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `reactome_rel` (
  `reactome_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `molecule_id` int(11) unsigned NOT NULL,
  KEY `reactome_id` (`reactome_id`),
  KEY `molecule_id` (`molecule_id`),
  CONSTRAINT `reactome_rel_ibfk_1` FOREIGN KEY (`molecule_id`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `reference`
--

DROP TABLE IF EXISTS `reference`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `reference` (
  `molecule_id` int(10) unsigned NOT NULL,
  `db` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`molecule_id`,`db`,`id`),
  KEY `molecule_id` (`molecule_id`),
  CONSTRAINT `reference_ibfk_1` FOREIGN KEY (`molecule_id`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `sequence`
--

DROP TABLE IF EXISTS `sequence`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `sequence` (
  `molecule_id` int(10) unsigned NOT NULL,
  `sequence` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  KEY `molecule_id` (`molecule_id`),
  CONSTRAINT `sequence_ibfk_1` FOREIGN KEY (`molecule_id`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `synonym`
--

DROP TABLE IF EXISTS `synonym`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `synonym` (
  `molecule_id` int(10) unsigned NOT NULL,
  `synonym` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`molecule_id`,`synonym`),
  CONSTRAINT `synonym_ibfk_1` FOREIGN KEY (`molecule_id`) REFERENCES `molecule` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `uniprot_reactome`
--

DROP TABLE IF EXISTS `uniprot_reactome`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `uniprot_reactome` (
  `uniprot_id` char(6) COLLATE utf8_unicode_ci NOT NULL,
  `reactome_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `uniprot_id` (`uniprot_id`,`reactome_id`),
  KEY `reactome_id` (`reactome_id`),
  CONSTRAINT `uniprot_reactome_ibfk_1` FOREIGN KEY (`reactome_id`) REFERENCES `reactome` (`reactome_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Final view structure for view `protein_interaction_filtered`
--

/*!50001 DROP TABLE `protein_interaction_filtered`*/;
/*!50001 DROP VIEW IF EXISTS `protein_interaction_filtered`*/;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`arzt`@`%` SQL SECURITY DEFINER */
/*!50001 VIEW `protein_interaction_filtered` AS select `pi`.`interaction_id` AS `id`,`pi`.`predicted` AS `predicted`,`pi`.`complex_ppi` AS `complex`,`pi`.`disease_ppi` AS `disease`,`pi`.`demerged` AS `demerged`,`m1`.`primary_uniprot_id` AS `from_id`,`m2`.`primary_uniprot_id` AS `to_id`,`d`.`db_source_name` AS `source`,`pi`.`experimental_role_a` AS `experimental_role_a`,`pi`.`experimental_role_b` AS `experimental_role_b`,`m1`.`tax_id` AS `tax_id` from (((`protein_interaction` `pi` join `molecule` `m1`) join `molecule` `m2`) join `db_source` `d`) where ((`pi`.`protein_id_a` = `m1`.`id`) and (`pi`.`protein_id_b` = `m2`.`id`) and (`d`.`db_source_id` = `pi`.`db_source_id`) and (`pi`.`disease_ppi` = '0') and ((`pi`.`complex_ppi` = '0') or ((`pi`.`complex_ppi` = '1') and (((`pi`.`experimental_role_a` = 'bait') and (`pi`.`experimental_role_b` = 'prey')) or ((`pi`.`experimental_role_a` = 'prey') and (`pi`.`experimental_role_b` = 'bait')) or ((`pi`.`experimental_role_a` = 'fluorescence donor') and (`pi`.`experimental_role_b` = 'fluorescence acceptor')) or ((`pi`.`experimental_role_a` = 'fluorescence acceptor') and (`pi`.`experimental_role_b` = 'fluorescence donor')))))) */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2011-03-31 13:35:54
