/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.uuw.services.remoting.blast;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.blast.Hit;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.model.blast.BlastResult;
import uk.ac.ebi.kraken.uuw.services.remoting.Query;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtQueryBuilder;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtRemoteServiceFactory;
import uk.ac.ebi.kraken.uuw.services.remoting.blast.BlastData;
import uk.ac.ebi.kraken.uuw.services.remoting.blast.BlastHit;

public class UniRefBlastData
extends BlastData<UniRefEntry> {
    List<BlastHit<UniRefEntry>> hits = new ArrayList<BlastHit<UniRefEntry>>();

    public UniRefBlastData(BlastResult blastResult) {
        super(blastResult);
        for (Hit hit : blastResult.getHits()) {
            this.hits.add(new BlastHit<UniRefEntry>(hit, this));
        }
    }

    @Override
    protected UniRefEntry retrieveEntry(Hit hit) {
        return this.service.getUniRefEntry(hit.getHitId());
    }

    @Override
    public Query getResultAsQuery() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BlastHit<UniRefEntry> blastHit : this.hits) {
            arrayList.add(blastHit.getHit().getHitId());
        }
        return UniProtQueryBuilder.buildIDListQuery(arrayList);
    }

    @Override
    public List<BlastHit<UniRefEntry>> getBlastHits() {
        if (this.service == null) {
            this.service = new UniProtRemoteServiceFactory().getEntryRetrievalService();
        }
        return this.hits;
    }
}

