/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.uuw.services.remoting.blast;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.blast.Hit;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.model.blast.BlastResult;
import uk.ac.ebi.kraken.uuw.services.remoting.Query;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtQueryBuilder;
import uk.ac.ebi.kraken.uuw.services.remoting.blast.BlastData;
import uk.ac.ebi.kraken.uuw.services.remoting.blast.BlastHit;

public class UniProtBlastData
extends BlastData<UniProtEntry> {
    List<BlastHit<UniProtEntry>> hits = new ArrayList<BlastHit<UniProtEntry>>();

    public UniProtBlastData(BlastResult blastResult) {
        super(blastResult);
        for (Hit hit : blastResult.getHits()) {
            this.hits.add(new BlastHit<UniProtEntry>(hit, this));
        }
    }

    @Override
    protected UniProtEntry retrieveEntry(Hit hit) {
        return this.service.getUniProtEntry(hit.getAc());
    }

    @Override
    public Query getResultAsQuery() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BlastHit<UniProtEntry> blastHit : this.hits) {
            arrayList.add(blastHit.getHit().getAc());
        }
        return UniProtQueryBuilder.buildIDListQuery(arrayList);
    }

    @Override
    public List<BlastHit<UniProtEntry>> getBlastHits() {
        return this.hits;
    }
}

