/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.uuw.services.remoting.blast;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.blast.Hit;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.model.blast.BlastResult;
import uk.ac.ebi.kraken.uuw.services.remoting.Query;
import uk.ac.ebi.kraken.uuw.services.remoting.UniParcQueryBuilder;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtRemoteServiceFactory;
import uk.ac.ebi.kraken.uuw.services.remoting.blast.BlastData;
import uk.ac.ebi.kraken.uuw.services.remoting.blast.BlastHit;

public class UniParcBlastData
extends BlastData<UniParcEntry> {
    List<BlastHit<UniParcEntry>> hits = new ArrayList<BlastHit<UniParcEntry>>();

    public UniParcBlastData(BlastResult blastResult) {
        super(blastResult);
        for (Hit hit : blastResult.getHits()) {
            this.hits.add(new BlastHit<UniParcEntry>(hit, this));
        }
    }

    @Override
    protected UniParcEntry retrieveEntry(Hit hit) {
        return this.service.getUniParcEntry(hit.getHitId());
    }

    @Override
    public Query getResultAsQuery() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BlastHit<UniParcEntry> blastHit : this.hits) {
            arrayList.add(blastHit.getHit().getHitId());
        }
        return UniParcQueryBuilder.buildIDListQuery(arrayList);
    }

    @Override
    public List<BlastHit<UniParcEntry>> getBlastHits() {
        if (this.service == null) {
            this.service = new UniProtRemoteServiceFactory().getEntryRetrievalService();
        }
        return this.hits;
    }
}

