/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.uuw.services.remoting.blast;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.ProteinData;
import uk.ac.ebi.kraken.interfaces.blast.Hit;
import uk.ac.ebi.kraken.model.blast.BlastResult;
import uk.ac.ebi.kraken.uuw.services.remoting.Query;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtJAPI;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtQueryBuilder;
import uk.ac.ebi.kraken.uuw.services.remoting.blast.BlastData;
import uk.ac.ebi.kraken.uuw.services.remoting.blast.BlastHit;

public class ProteinDataBlastData
extends BlastData<ProteinData> {
    List<BlastHit<ProteinData>> hits = new ArrayList<BlastHit<ProteinData>>();

    public ProteinDataBlastData(BlastResult blastResult) {
        super(blastResult);
        for (Hit hit : blastResult.getHits()) {
            this.hits.add(new BlastHit<ProteinData>(hit, this));
        }
    }

    @Override
    protected ProteinData retrieveEntry(Hit hit) {
        return this.service.getProteinData(hit.getAc());
    }

    @Override
    public Query getResultAsQuery() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BlastHit<ProteinData> blastHit : this.hits) {
            arrayList.add(blastHit.getHit().getAc());
        }
        return UniProtQueryBuilder.buildIDListQuery(arrayList);
    }

    @Override
    public List<BlastHit<ProteinData>> getBlastHits() {
        if (this.service == null) {
            this.service = UniProtJAPI.factory.getEntryRetrievalService();
        }
        return this.hits;
    }
}

