/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.uuw.services.remoting;

import java.util.BitSet;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.model.blast.JobStatus;
import uk.ac.ebi.kraken.uuw.services.remoting.AccessionIterator;
import uk.ac.ebi.kraken.uuw.services.remoting.AttributeIterator;
import uk.ac.ebi.kraken.uuw.services.remoting.BitSetEntryIterator;
import uk.ac.ebi.kraken.uuw.services.remoting.EntryIterator;
import uk.ac.ebi.kraken.uuw.services.remoting.EntryRetrievalService;
import uk.ac.ebi.kraken.uuw.services.remoting.PagingService;
import uk.ac.ebi.kraken.uuw.services.remoting.Query;
import uk.ac.ebi.kraken.uuw.services.remoting.RemoteDataAccessException;
import uk.ac.ebi.kraken.uuw.services.remoting.SetOperation;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtEntryIterator;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtQueryService;
import uk.ac.ebi.kraken.uuw.services.remoting.blast.BlastData;
import uk.ac.ebi.kraken.uuw.services.remoting.blast.BlastInput;

public class UniProtQueryServiceClientImpl
implements UniProtQueryService {
    private UniProtQueryService service;
    private PagingService<UniProtEntry> pagingService;
    private EntryRetrievalService entryService;

    public UniProtQueryServiceClientImpl(UniProtQueryService uniProtQueryService, PagingService<UniProtEntry> pagingService, EntryRetrievalService entryRetrievalService) {
        this.service = uniProtQueryService;
        this.entryService = entryRetrievalService;
        this.pagingService = pagingService;
    }

    @Override
    public UniProtEntryIterator getEntries(Query query) throws RemoteDataAccessException {
        UniProtEntryIterator uniProtEntryIterator = this.service.getEntries(query);
        uniProtEntryIterator.setPagingService(this.pagingService);
        return uniProtEntryIterator;
    }

    @Override
    public AccessionIterator<UniProtEntry> getUniProtAccessions(Query query) throws RemoteDataAccessException {
        AccessionIterator accessionIterator = this.service.getUniProtAccessions(query);
        accessionIterator.setPagingService(this.pagingService);
        return accessionIterator;
    }

    @Override
    public EntryIterator<UniProtEntry> getEntryIterator(EntryIterator<UniProtEntry> entryIterator, SetOperation setOperation, EntryIterator<UniProtEntry> entryIterator2) throws RemoteDataAccessException {
        BitSetEntryIterator bitSetEntryIterator = (BitSetEntryIterator)entryIterator;
        BitSetEntryIterator bitSetEntryIterator2 = (BitSetEntryIterator)entryIterator2;
        BitSet bitSet = (BitSet)bitSetEntryIterator.getBitSet().clone();
        BitSet bitSet2 = bitSetEntryIterator2.getBitSet();
        switch (setOperation) {
            case AndNot: {
                bitSet.andNot(bitSet2);
                break;
            }
            case And: {
                bitSet.and(bitSet2);
                break;
            }
            case Or: {
                bitSet.or(bitSet2);
            }
        }
        BitSetEntryIterator<UniProtEntry> bitSetEntryIterator3 = new BitSetEntryIterator<UniProtEntry>();
        bitSetEntryIterator3.setBitSet(bitSet);
        bitSetEntryIterator3.setPagingService(this.pagingService);
        return bitSetEntryIterator3;
    }

    @Override
    public BitSetEntryIterator<UniProtEntry> getEntryIterator(Query query) throws RemoteDataAccessException {
        BitSetEntryIterator bitSetEntryIterator = (BitSetEntryIterator)this.service.getEntryIterator(query);
        bitSetEntryIterator.setPagingService(this.pagingService);
        return bitSetEntryIterator;
    }

    @Override
    public AccessionIterator<UniProtEntry> getAccessions(Query query) throws RemoteDataAccessException {
        AccessionIterator<UniProtEntry> accessionIterator = this.service.getAccessions(query);
        accessionIterator.setPagingService(this.pagingService);
        return accessionIterator;
    }

    @Override
    public AttributeIterator<UniProtEntry> getAttributes(Query query, String string) throws RemoteDataAccessException {
        AttributeIterator<UniProtEntry> attributeIterator = this.service.getAttributes(query, string);
        attributeIterator.setPagingService(this.pagingService);
        return attributeIterator;
    }

    @Override
    public BlastData<UniProtEntry> getResults(String string) {
        BlastData<UniProtEntry> blastData = this.service.getResults(string);
        blastData.setEntryRetrievalService(this.entryService);
        return blastData;
    }

    @Override
    public JobStatus checkStatus(String string) {
        return this.service.checkStatus(string);
    }

    @Override
    public String submitBlast(BlastInput blastInput) {
        return this.service.submitBlast(blastInput);
    }
}

