/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.uuw.services.remoting;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.util.IndexField;
import uk.ac.ebi.kraken.uuw.services.remoting.Query;

public class UniProtQueryBuilder {
    public static Query buildQuery(String string) {
        return new Query(string);
    }

    public static Query buildProteinNameQuery(String string) {
        return new Query(IndexField.PROTEIN_NAME.getValue() + ":" + string);
    }

    public static Query buildExactMatchIdentifierQuery(String string) {
        return new Query(IndexField.UNIPROT_IDENTIFIER.getValue() + ":" + string);
    }

    public static Query buildOrganismQuery(String string) {
        return new Query(IndexField.ORGANISM_NAMES.getValue() + ":" + string);
    }

    @Deprecated
    public static Query buildDatabaseCrossRefernceQuery(String string) {
        return new Query(IndexField.DATABASE_CROSSREFERENCES.getValue() + ":" + string);
    }

    public static Query buildDatabaseCrossReferenceQuery(String string) {
        return new Query(IndexField.DATABASE_CROSSREFERENCES.getValue() + ":" + string);
    }

    public static Query buildDatabaseCrossReferenceQuery(DatabaseType databaseType, String string) {
        return new Query(IndexField.DATABASE_CROSSREFERENCES.getValueForType(databaseType) + ":" + string);
    }

    @Deprecated
    public static Query buildDatabaseCrossRefernceQuery(DatabaseType databaseType, String string) {
        return new Query(IndexField.DATABASE_CROSSREFERENCES.getValueForType(databaseType) + ":" + string);
    }

    public static Query buildECNumberQuery(String string) {
        return new Query(IndexField.EC_NUMBER.getValue() + ":" + string);
    }

    public static Query buildGeneNameQuery(String string) {
        return new Query(IndexField.GENE_NAME.getValue() + ":" + string);
    }

    public static Query buildKeywordQuery(String string) {
        return new Query(IndexField.KEYWORD.getValue() + ":" + string);
    }

    public static Query buildGOTermsQuery(String string) {
        return new Query(IndexField.GO_TERMS.getValue() + ":" + string);
    }

    public static Query buildFullTextSearch(String string) {
        Query query = new Query(string);
        query.setFullText(true);
        return query;
    }

    public static Query buildUpdatedQuery(Date date, Date date2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("updated:[");
        stringBuilder.append(DateFormat.getDateInstance().format(date));
        stringBuilder.append(" TO ");
        stringBuilder.append(DateFormat.getDateInstance().format(date2));
        stringBuilder.append("]");
        return new Query(stringBuilder.toString());
    }

    public static Query buildCreatedQuery(Date date, Date date2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("created:[");
        stringBuilder.append(DateFormat.getDateInstance().format(date));
        stringBuilder.append(" TO ");
        stringBuilder.append(DateFormat.getDateInstance().format(date2));
        stringBuilder.append("]");
        return new Query(stringBuilder.toString());
    }

    public static Query buildIDListQuery(List<String> list) {
        return new Query(list);
    }

    public static Query setReviewedEntries(Query query) {
        String string = query.toString();
        String string2 = string.concat(" reviewed:yes ");
        Query query2 = new Query(string2);
        query2.setFullText(query.isFullText());
        return query2;
    }

    public static Query setUnreviewedEntries(Query query) {
        String string = query.toString();
        String string2 = string.concat(" unreviewed:yes ");
        Query query2 = new Query(string2);
        query2.setFullText(query.isFullText());
        return query2;
    }
}

