/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.uuw.services.remoting;

import java.io.IOException;
import java.util.Properties;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;
import uk.ac.ebi.kraken.uuw.services.remoting.AdminService;
import uk.ac.ebi.kraken.uuw.services.remoting.EntryRetrievalService;
import uk.ac.ebi.kraken.uuw.services.remoting.PagingService;
import uk.ac.ebi.kraken.uuw.services.remoting.ProteinDataQueryService;
import uk.ac.ebi.kraken.uuw.services.remoting.ProteinDataQueryServiceClientImpl;
import uk.ac.ebi.kraken.uuw.services.remoting.RemoteDataAccessException;
import uk.ac.ebi.kraken.uuw.services.remoting.UniParcQueryService;
import uk.ac.ebi.kraken.uuw.services.remoting.UniParcQueryServiceClientImpl;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtQueryService;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtQueryServiceClientImpl;
import uk.ac.ebi.kraken.uuw.services.remoting.UniRefQueryService;
import uk.ac.ebi.kraken.uuw.services.remoting.UniRefQueryServiceClientImpl;

public enum UniProtJAPI {
    factory;

    private XmlBeanFactory xmlBeanFactory;

    private UniProtJAPI() {
        try {
            this.xmlBeanFactory = new XmlBeanFactory(new ClassPathResource("remotingClient.xml"));
            Properties properties = new Properties();
            properties.load(new ClassPathResource("remote_client.properties").getInputStream());
            PropertyPlaceholderConfigurer propertyPlaceholderConfigurer = new PropertyPlaceholderConfigurer();
            propertyPlaceholderConfigurer.setProperties(properties);
            ClassPathResource classPathResource = new ClassPathResource("uniprotjapi.properties");
            if (classPathResource.exists()) {
                propertyPlaceholderConfigurer.setLocation(classPathResource);
            }
            propertyPlaceholderConfigurer.postProcessBeanFactory(this.xmlBeanFactory);
        }
        catch (IOException iOException) {
            throw new RemoteDataAccessException("Unable to start xmlBeanFactory", iOException);
        }
    }

    public EntryRetrievalService getEntryRetrievalService() {
        return (EntryRetrievalService)this.xmlBeanFactory.getBean("entryRetrievalProxy");
    }

    public UniProtQueryService getUniProtQueryService() {
        UniProtQueryService uniProtQueryService = (UniProtQueryService)this.xmlBeanFactory.getBean("queryServiceProxy");
        PagingService pagingService = (PagingService)this.xmlBeanFactory.getBean("pagingServiceProxy");
        EntryRetrievalService entryRetrievalService = (EntryRetrievalService)this.xmlBeanFactory.getBean("entryRetrievalProxy");
        UniProtQueryServiceClientImpl uniProtQueryServiceClientImpl = new UniProtQueryServiceClientImpl(uniProtQueryService, pagingService, entryRetrievalService);
        return uniProtQueryServiceClientImpl;
    }

    public UniRefQueryService getUniRefQueryService() {
        UniRefQueryService uniRefQueryService = (UniRefQueryService)this.xmlBeanFactory.getBean("uniRefQueryServiceProxy");
        EntryRetrievalService entryRetrievalService = (EntryRetrievalService)this.xmlBeanFactory.getBean("entryRetrievalProxy");
        UniRefQueryServiceClientImpl uniRefQueryServiceClientImpl = new UniRefQueryServiceClientImpl(uniRefQueryService, entryRetrievalService);
        return uniRefQueryServiceClientImpl;
    }

    public ProteinDataQueryService getProteinDataQueryService() {
        ProteinDataQueryService proteinDataQueryService = (ProteinDataQueryService)this.xmlBeanFactory.getBean("pdQueryServiceProxy");
        PagingService pagingService = (PagingService)this.xmlBeanFactory.getBean("pdPagingServiceProxy");
        EntryRetrievalService entryRetrievalService = (EntryRetrievalService)this.xmlBeanFactory.getBean("entryRetrievalProxy");
        ProteinDataQueryServiceClientImpl proteinDataQueryServiceClientImpl = new ProteinDataQueryServiceClientImpl(proteinDataQueryService, pagingService, entryRetrievalService);
        return proteinDataQueryServiceClientImpl;
    }

    public UniParcQueryService getUniParcQueryService() {
        UniParcQueryService uniParcQueryService = (UniParcQueryService)this.xmlBeanFactory.getBean("uniParcQueryServiceProxy");
        PagingService pagingService = (PagingService)this.xmlBeanFactory.getBean("uniParcPagingServiceProxy");
        EntryRetrievalService entryRetrievalService = (EntryRetrievalService)this.xmlBeanFactory.getBean("entryRetrievalProxy");
        UniParcQueryServiceClientImpl uniParcQueryServiceClientImpl = new UniParcQueryServiceClientImpl(uniParcQueryService, pagingService, entryRetrievalService);
        return uniParcQueryServiceClientImpl;
    }

    public String getVersion() throws RemoteDataAccessException {
        AdminService adminService = (AdminService)this.xmlBeanFactory.getBean("adminServiceProxy");
        return adminService.getVersion();
    }
}

