/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.uuw.services.remoting;

import java.util.List;
import uk.ac.ebi.kraken.util.IndexField;
import uk.ac.ebi.kraken.uuw.services.remoting.Query;

public class UniParcQueryBuilder {
    public static Query buildCrossReferenceQuery(String string) {
        return new Query(IndexField.UNIPARC_DATABASE_CROSSREFERENCES.getValue() + ":" + string);
    }

    public static Query buildActiveCrossReferenceQuery(String string) {
        return new Query(IndexField.UNIPARC_ACTIVE_CROSSREFERENCES.getValue() + ":" + string);
    }

    public static Query buildCrc64Query(String string) {
        return new Query(IndexField.SEQUENCE_CRC64.getValue() + ":" + string);
    }

    public static Query buildFullTextSearch(String string) {
        Query query = new Query(string);
        query.setFullText(true);
        return query;
    }

    public static Query buildSequenceLengthQuery(Long l, Long l2) {
        if (l == null || l2 == null) {
            throw new NullPointerException("Lengths must not be null");
        }
        if (l < 0L) {
            throw new UnsupportedOperationException("You must supply a FROM length that is zero(0) or greated");
        }
        if (l2 < l) {
            throw new UnsupportedOperationException("You must supply a TO length that is the same or greater than the FROM length ");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(IndexField.SEQUENCE_LENGTH.getValue());
        stringBuilder.append(":[");
        stringBuilder.append(l.toString());
        stringBuilder.append(" TO ");
        stringBuilder.append(l2.toString());
        stringBuilder.append("]");
        return new Query(stringBuilder.toString());
    }

    public static Query buildIDListQuery(List<String> list) {
        return new Query(list);
    }
}

