/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.uuw.services.remoting;

import java.util.BitSet;
import uk.ac.ebi.kraken.model.blast.JobStatus;
import uk.ac.ebi.kraken.uuw.services.remoting.AccessionIterator;
import uk.ac.ebi.kraken.uuw.services.remoting.AttributeIterator;
import uk.ac.ebi.kraken.uuw.services.remoting.BitSetEntryIterator;
import uk.ac.ebi.kraken.uuw.services.remoting.EntryIterator;
import uk.ac.ebi.kraken.uuw.services.remoting.EntryRetrievalService;
import uk.ac.ebi.kraken.uuw.services.remoting.PagingService;
import uk.ac.ebi.kraken.uuw.services.remoting.Query;
import uk.ac.ebi.kraken.uuw.services.remoting.QueryService;
import uk.ac.ebi.kraken.uuw.services.remoting.RemoteDataAccessException;
import uk.ac.ebi.kraken.uuw.services.remoting.SetOperation;
import uk.ac.ebi.kraken.uuw.services.remoting.blast.BlastData;
import uk.ac.ebi.kraken.uuw.services.remoting.blast.BlastInput;

public class ServiceClientImpl<T>
implements QueryService<T> {
    private QueryService<T> service;
    private EntryRetrievalService entryService;
    private PagingService<T> pagingService;

    public ServiceClientImpl(QueryService<T> queryService, PagingService<T> pagingService, EntryRetrievalService entryRetrievalService) {
        this.service = queryService;
        this.pagingService = pagingService;
        this.entryService = entryRetrievalService;
    }

    @Override
    public EntryIterator<T> getEntryIterator(EntryIterator<T> entryIterator, SetOperation setOperation, EntryIterator<T> entryIterator2) throws RemoteDataAccessException {
        BitSetEntryIterator bitSetEntryIterator = (BitSetEntryIterator)entryIterator;
        BitSetEntryIterator bitSetEntryIterator2 = (BitSetEntryIterator)entryIterator2;
        BitSet bitSet = (BitSet)bitSetEntryIterator.getBitSet().clone();
        BitSet bitSet2 = bitSetEntryIterator2.getBitSet();
        switch (setOperation) {
            case AndNot: {
                bitSet.andNot(bitSet2);
                break;
            }
            case And: {
                bitSet.and(bitSet2);
                break;
            }
            case Or: {
                bitSet.or(bitSet2);
            }
        }
        BitSetEntryIterator bitSetEntryIterator3 = new BitSetEntryIterator();
        bitSetEntryIterator3.setBitSet(bitSet);
        bitSetEntryIterator3.setPagingService(this.pagingService);
        return bitSetEntryIterator3;
    }

    @Override
    public BitSetEntryIterator<T> getEntryIterator(Query query) throws RemoteDataAccessException {
        BitSetEntryIterator bitSetEntryIterator = (BitSetEntryIterator)this.service.getEntryIterator(query);
        bitSetEntryIterator.setPagingService(this.pagingService);
        return bitSetEntryIterator;
    }

    @Override
    public AccessionIterator<T> getAccessions(Query query) throws RemoteDataAccessException {
        AccessionIterator<T> accessionIterator = this.service.getAccessions(query);
        accessionIterator.setPagingService(this.pagingService);
        return accessionIterator;
    }

    @Override
    public AttributeIterator<T> getAttributes(Query query, String string) throws RemoteDataAccessException {
        AttributeIterator<T> attributeIterator = this.service.getAttributes(query, string);
        attributeIterator.setPagingService(this.pagingService);
        return attributeIterator;
    }

    @Override
    public BlastData<T> getResults(String string) {
        BlastData blastData = this.service.getResults(string);
        blastData.setEntryRetrievalService(this.entryService);
        return blastData;
    }

    @Override
    public JobStatus checkStatus(String string) {
        return this.service.checkStatus(string);
    }

    @Override
    public String submitBlast(BlastInput blastInput) {
        return this.service.submitBlast(blastInput);
    }
}

