/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.uuw.services.remoting;

import java.io.Serializable;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class HttpClientFactoryBean
implements FactoryBean,
InitializingBean,
Serializable {
    private HttpClient httpClient = null;
    private String username = null;
    private String password = null;
    private String proxyHost = null;
    private String proxyPort = null;

    public Object getObject() throws Exception {
        return this.httpClient;
    }

    public Class getObjectType() {
        return HttpClient.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setProxyHost(String string) {
        this.proxyHost = string;
    }

    public void setProxyPort(String string) {
        this.proxyPort = string;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
        multiThreadedHttpConnectionManager.getParams().setMaxTotalConnections(30);
        multiThreadedHttpConnectionManager.getParams().setConnectionTimeout(60000);
        this.httpClient = new HttpClient(multiThreadedHttpConnectionManager);
        if (this.proxyHost != null && this.proxyHost.length() > 0) {
            this.httpClient.getHostConfiguration().setProxy(this.proxyHost, Integer.parseInt(this.proxyPort));
            if (this.username != null && this.username.length() > 0) {
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.username, this.password);
                this.httpClient.getState().setCredentials(new AuthScope(this.proxyHost, Integer.parseInt(this.proxyPort)), usernamePasswordCredentials);
            }
        }
    }
}

