/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.uuw.services.remoting;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import uk.ac.ebi.kraken.uuw.services.remoting.EntryIterator;
import uk.ac.ebi.kraken.uuw.services.remoting.PagingService;
import uk.ac.ebi.kraken.uuw.services.remoting.Query;

public abstract class AbstractEntryIterator<TYPE, PAGER>
implements EntryIterator<TYPE>,
Serializable {
    public static final long serialVersionUID = -1189806327625849989L;
    protected int pageSize = 100;
    protected int currentPage;
    protected int currentPosition = 0;
    protected int currentPagePosition = 0;
    protected int resultSize;
    protected Query term;
    protected List<TYPE> entries;
    protected BitSet set;
    protected PagingService<PAGER> pagingService;

    @Override
    public TYPE next() {
        if (this.pagingService == null) {
            System.out.println("pagingService is not set!!!");
            return null;
        }
        if (this.entries == null) {
            this.loadEntries(this.currentPage);
        }
        if (this.currentPagePosition >= this.pageSize) {
            this.currentPagePosition = 0;
            ++this.currentPage;
            this.loadEntries(this.currentPage);
        }
        if (this.entries != null && this.currentPosition < this.resultSize) {
            ++this.currentPosition;
            return this.entries.get(this.currentPagePosition++);
        }
        return null;
    }

    protected abstract void loadEntries(int var1);

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.currentPosition < this.resultSize;
    }

    @Override
    public Iterator<TYPE> iterator() {
        return this;
    }

    @Override
    public int getResultSize() {
        return this.resultSize;
    }

    void setResultSize(int n) {
        this.resultSize = n;
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    void setTerm(Query query) {
        this.term = query;
    }

    public void setSet(BitSet bitSet) {
        this.set = bitSet;
    }

    public void setPagingService(PagingService<PAGER> pagingService) {
        this.pagingService = pagingService;
    }
}

