/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationTypeEnum;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;

public enum IndexField {
    HID("__HID", Tokens.NOT_TOKENIZED),
    REVIEWED("reviewed"),
    CREATION_DATE("created", Format.DATE),
    UPDATED_DATE("updated", Format.DATE),
    UNIPROT_IDENTIFIER("identifier", Tokens.NOT_TOKENIZED),
    UNIPROT_EXPIRED_IDENTIFIER("expired"),
    UNIPROT_ID("id"),
    PRIMARY_ACCESSION("ac", 1.6f, new Enum[0]),
    PRIMARY_ACCESSION_EXACT("byac", Tokens.NOT_TOKENIZED, Save.NOT_SAVED),
    NAME_ANNOTATION("nameannotation", 1.2f, Save.NOT_SAVED),
    PROTEIN_EXISTANCE("pe"),
    FRAGMENT("fragment"),
    PROTEIN_NAME("proteinname"),
    REC_NAME("recname", Save.NOT_SAVED),
    ALT_NAME("altname", Save.NOT_SAVED),
    INCLUDES_SECTION("de.includes", Save.NOT_SAVED, Tokens.NOT_TOKENIZED),
    CONTAINS_SECTION("de.contains", Save.NOT_SAVED, Tokens.NOT_TOKENIZED),
    EC_NUMBER("ec"),
    REC_EC_NUMBER("rec.ec", Save.NOT_SAVED),
    PROTEIN_DESCRIPTION_MOD("protein.desc_mod"),
    PROTEIN_FRAGMENTATION("protein.frag_type"),
    GENE_EXACT("gene", Tokens.NOT_TOKENIZED, Save.NOT_SAVED),
    GENE_ANNOTATION("gene.annotation", Save.NOT_SAVED),
    GENE_NAME("gene.name"),
    GENE_SYNONYM("gene.synonym"),
    GENE_ORDERED_LOCUS("gene.oln"),
    GENE_ORF("gene.orf"),
    GENE_NAME_EXACT("gene.name.exact", Tokens.NOT_TOKENIZED, Save.NOT_SAVED),
    GENE_SYNONYM_EXACT("gene.synonym.exact", Tokens.NOT_TOKENIZED, Save.NOT_SAVED),
    KEYWORD("keyword"),
    KEYWORD_EXACT("keyword.exact", Tokens.NOT_TOKENIZED, Save.NOT_SAVED),
    GO_TERMS("GO"),
    TEXT_COMMENTS("comment", (Enum[])CommentType.values(), new Enum[]{Save.NOT_SAVED}),
    TEXT_COMMENTS_NO_STATUS("comment.no.status", (Enum[])CommentType.values(), new Enum[]{Save.NOT_SAVED}),
    ORGANISM_SPECIFIC("organism", Save.NOT_SAVED),
    ORGANISM_NAMES("organism.name"),
    ORGANISM_SCIENTIFIC("organism.scientific"),
    ORGANISM_SYNONYM("organism.synonym"),
    ORGANISM_COMMON("organism.common"),
    ORGANELLE("organism.organelle"),
    ORGANELLE_EXACT("organelle", Tokens.NOT_TOKENIZED),
    ORGANISM_HOST("organism.host", Save.NOT_SAVED),
    NCBI_TAXON_ID("organism.ncbi"),
    TAXONOMY_NAME("organism.taxon"),
    SEQUENCE_LENGTH("sequence.length", Tokens.NOT_TOKENIZED, Format.NUMERIC),
    SEQUENCE_CRC64("sequence.crc64", Tokens.NOT_TOKENIZED),
    DATABASE_CROSSREFERENCES("xref", (Enum[])DatabaseType.values(), new Enum[]{Save.NOT_SAVED}),
    POSITIONAL_SPECIFIC("feature", (Enum[])FeatureType.values(), new Enum[]{Save.NOT_SAVED}),
    LITERATURE("lit", (Enum[])CitationTypeEnum.values(), new Enum[]{Save.NOT_SAVED}),
    LITERATURE_AUTHORS("lit.authors"),
    LITERATURE_EXPERIMENTS("lit.experiment"),
    LITERATURE_SAMPLE_SOURCE("lit.samplesource"),
    LITERATURE_PUBMED("lit.pubmed"),
    LITERATURE_MEDLINE("lit.medlin"),
    LITERATURE_YEAR("lit.year", Save.NOT_SAVED),
    INTERPRO_GROUP("interpro"),
    INTERPRO_GROUP_ACC("interpro.accession"),
    INTERPRO_ENTRY_SP("interpro.sp"),
    INTERPRO_ENTRY_TR("interpro.tr"),
    INTERPRO_MATCH("match"),
    INTERPRO_MATCH_ACC("match.accession"),
    INTERPRO_MATCH_SCORE("match.score", Format.NUMERIC),
    HAS_PREDICTION("has_prediction"),
    CONTENT("content", Save.NOT_SAVED),
    KEYWORD_ID("keyword id"),
    KEYWORD_AC("keyword ac"),
    KEYWORD_SYNONYM("keyword synonym"),
    KEYWORD_GOMAPPING("keyword gomapping"),
    UNIREF_IDENTITY("identity"),
    UNIREF_DESCRIPTION("description"),
    UNIREF_ORGANISM("organism"),
    UNIREF_MEMBER_ACCESSION("member.accession", Tokens.NOT_TOKENIZED, Save.NOT_SAVED),
    UNIREF_ACCESSION("ac"),
    UNIREF_MEMBER_NUMBER("member.no", Format.NUMERIC),
    UNIPARC_ACCESSION("ac"),
    UNIPARC_DATABASE_CROSSREFERENCES("xref", Save.NOT_SAVED),
    UNIPARC_ACTIVE_CROSSREFERENCES("xref.active", Save.NOT_SAVED),
    UNIPARC_UNIPROT_CROSSREFERENCES("uniprot"),
    PREDICTION_VALUE("prediction"),
    PREDICTION_CLASSIFIER("classifier"),
    PREDICTION_MODEL("model"),
    PREDICTION_SCORE("score", Format.NUMERIC),
    PREDICTION_CONFIDENCE("confidence", Format.NUMERIC),
    PREDICTION_RESULT("result"),
    PREDICTION_ENTRY("accession"),
    PREDICTION_TYPE("prediction_type"),
    PREDICTION_CONDITION("condition", Save.SAVE, Tokens.NOT_TOKENIZED),
    PREDICTION_IMPORTED("imported"),
    PREDICTION_COMMENT_TYPE("commenttype"),
    PREDICTION_CONDITION_TYPE("cond_type", Save.SAVE, Tokens.NOT_TOKENIZED),
    UNIMES_ACCESSION("unimesid", Save.SAVE),
    UNIMES_PEPTIDE_ID("peptideid", Save.SAVE),
    UNIMES_PROTEIN_DESCRIPTION("protein_description", Save.SAVE),
    UNIMES_ORGANISM("unimes_organism", Save.SAVE),
    RB_RULE_ID("rule", Save.SAVE),
    RB_ACTION_ID("aid", Save.SAVE),
    RB_CONDITION_ID("cid", Save.SAVE),
    RB_RULE_CONDITION("condition", Save.SAVE),
    RB_RULE_ACTION("action", Save.SAVE),
    UR_ID("ur.id", Sort.SORTED),
    UR_CREATED("rcreated", Format.TIME, Sort.SORTED),
    UR_UPDATED("rupdated", Format.TIME, Sort.SORTED),
    UR_CREATOR("rcreator", Sort.SORTED),
    UR_CONFIDENCE("conf.full", Sort.SORTED, Format.BIG_NUMERIC),
    UR_SENSITIVITY("sensitivity.full", Sort.SORTED, Format.BIG_NUMERIC),
    UR_COVERAGE_SP("coverage.sp", Sort.SORTED, Format.BIG_NUMERIC),
    UR_COVERAGE_TR("coverage.tr", Sort.SORTED, Format.BIG_NUMERIC),
    UR_CONFIDENCE_PERC("conf"),
    UR_SENSITIVITY_PERC("sensitivity"),
    UR_OLD_RULE_ID("oldid", Sort.SORTED),
    UR_RELATED_RULES("related", Sort.SORTED, Format.NUMERIC),
    UR_CHILDREN_RULES("cases", Sort.SORTED, Format.NUMERIC),
    UR_AJ_FP("fp", Sort.SORTED, Format.BIG_NUMERIC),
    UR_AJ_TP("tp", Sort.SORTED, Format.BIG_NUMERIC),
    UR_UNAJ_FP("uafp", Sort.SORTED, Format.BIG_NUMERIC),
    UR_UNAJ_TP("uatp", Sort.SORTED, Format.BIG_NUMERIC),
    UR_TREMBL("trembl", Sort.SORTED, Format.BIG_NUMERIC),
    UR_PROTEIN_NAME("pname", Sort.SORTED),
    UR_ANNOTATIONS("annotations"),
    UR_ANNOTATION_TYPE("annotation.type", Sort.SORTED),
    UR_CONDITION_TYPE("condition.type", Sort.SORTED),
    UR_CONDITIONS("conditions"),
    UR_INFORMATION("information"),
    UR_NEG("neg", Sort.SORTED),
    UR_COMMENT("comment"),
    UR_VALUE("ur.value", Sort.SORTED),
    UR_STATUS("status", Sort.SORTED);

    private String name;
    private Sort sort = Sort.UN_SORTED;
    private Save save = Save.SAVE;
    private Tokens token = Tokens.TOKENIZED;
    private List<Enum> types = null;
    private float boost = 1.0f;
    private Format fieldType = Format.TEXT;

    private IndexField(String name) {
        this.name = name;
    }

    private IndexField(String name, Enum[] types, Enum ... props) {
        this(name, props);
        if (types != null) {
            this.types = new ArrayList<Enum>();
            for (Enum e : types) {
                this.types.add(e);
            }
        }
    }

    private IndexField(String name, float boost, Enum ... props) {
        this(name, props);
        this.boost = boost;
    }

    private IndexField(String name, Enum ... props) {
        this(name);
        for (Enum en : props) {
            if (en instanceof Format) {
                this.fieldType = (Format)en;
                continue;
            }
            if (en instanceof Sort) {
                this.sort = (Sort)en;
                continue;
            }
            if (en instanceof Tokens) {
                this.token = (Tokens)en;
                continue;
            }
            if (!(en instanceof Save)) continue;
            this.save = (Save)en;
        }
    }

    public float getBoost() {
        return this.boost;
    }

    public String getValue() {
        return this.name;
    }

    public List<Enum> getTypeForIndexField() {
        return this.types;
    }

    public List<String> getValueForAllTypes() {
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.types != null) {
            for (Enum en : this.types) {
                retVal.add(this.getValueForType(en));
            }
        } else {
            throw new IllegalArgumentException("There is no types for this IndexField");
        }
        return retVal;
    }

    public String getValueForType(Enum en) {
        StringBuilder sb = new StringBuilder();
        if (this.types == null) {
            throw new IllegalArgumentException("There is no types for this IndexField");
        }
        sb.append(this.toString()).append(".").append(en.toString());
        return sb.toString().toLowerCase().replaceAll(" ", "");
    }

    public String toString() {
        return this.name;
    }

    public boolean isFieldSaved() {
        return this.save == Save.SAVE;
    }

    public boolean isSortable() {
        return this.sort == Sort.SORTED;
    }

    public boolean isTokenized() {
        return this.token == Tokens.TOKENIZED;
    }

    public String getSortName() {
        if (this.isSortable()) {
            return "__SORT_" + this.name;
        }
        return null;
    }

    public Format getFieldType() {
        return this.fieldType;
    }

    public static IndexField typeOf(String value) {
        for (IndexField field : IndexField.values()) {
            if (field.getValue().equals(value)) {
                return field;
            }
            if (!field.hasTypes()) continue;
            for (String typeNames : field.getValueForAllTypes()) {
                if (!typeNames.equals(value)) continue;
                return field;
            }
        }
        throw new IllegalArgumentException("The IndexField with the name " + value + " is not supported");
    }

    public boolean hasTypes() {
        return this.types != null;
    }

    private static enum Tokens {
        TOKENIZED,
        NOT_TOKENIZED;

    }

    private static enum Save {
        SAVE,
        NOT_SAVED;

    }

    private static enum Sort {
        SORTED,
        UN_SORTED;

    }

    public static enum Format {
        TEXT,
        NUMERIC,
        BIG_NUMERIC,
        DATE,
        TIME;

    }
}

