/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.interfaces.util.CollectionOrderer;

public class CollectionOrdererImpl<T>
implements CollectionOrderer<T> {
    private FileReader fileReader;
    private String inputFile = "C:/dr_ord.txt";
    private Collection<T> collection;

    public CollectionOrdererImpl(Collection<T> collection) {
        this.collection = collection;
    }

    @Override
    public List<T> getListOrdered() {
        List<Object> result = new ArrayList();
        if (this.collection.size() == 0) {
            return result;
        }
        T t = this.collection.iterator().next();
        if (t instanceof DatabaseCrossReference) {
            result = this.getListDBXRef();
        } else if (t instanceof Feature) {
            result = this.getListFeature();
        }
        return result;
    }

    private List<T> getListDBXRefThroughFile() throws IOException {
        String dbName;
        ArrayList<DatabaseCrossReference> listDBCrossReferences = new ArrayList<DatabaseCrossReference>();
        Collection<T> collectionDBCrossReferences = this.collection;
        this.fileReader = new FileReader(this.inputFile);
        boolean c = false;
        BufferedReader in = new BufferedReader(this.fileReader);
        boolean firstDBXref = false;
        while ((dbName = in.readLine()) != null) {
            if (dbName.startsWith("#")) continue;
            DatabaseType dbType = DatabaseType.getDatabaseType(dbName.substring(0, dbName.indexOf(" ")));
            if (dbType == DatabaseType.UNKNOWN) {
                System.err.println("The name " + dbName + " is not correct");
            }
            for (DatabaseCrossReference databaseCrossReference : collectionDBCrossReferences) {
                if (databaseCrossReference.getDatabase() != dbType) continue;
                listDBCrossReferences.add(databaseCrossReference);
            }
        }
        in.close();
        return listDBCrossReferences;
    }

    private List<T> getListDBXRef() {
        ArrayList<DatabaseCrossReference> listDBCrossReferences = new ArrayList<DatabaseCrossReference>();
        Collection<T> collectionDBCrossReferences = this.collection;
        boolean firstDBXref = false;
        for (DatabaseType dbType : DatabaseType.values()) {
            if (dbType == DatabaseType.UNKNOWN) continue;
            for (DatabaseCrossReference databaseCrossReference : collectionDBCrossReferences) {
                if (databaseCrossReference.getDatabase() != dbType) continue;
                listDBCrossReferences.add(databaseCrossReference);
            }
        }
        return listDBCrossReferences;
    }

    private List<T> getListFeature() {
        ArrayList<Feature> listFeatures = new ArrayList<Feature>();
        Collection<T> collectionFeatures = this.collection;
        for (FeatureType featureType : FeatureType.values()) {
            for (Feature feature : collectionFeatures) {
                if (feature.getType() != featureType) continue;
                listFeatures.add(feature);
            }
        }
        return listFeatures;
    }
}

