/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniref.member;

import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefRepresentativeMember;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.common.SequenceImpl;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.kraken.model.uniref.member.UniRefMemberImpl;
import uk.ac.ebi.kraken.util.IndexField;

public class UniRefRepresentativeMemberImpl
extends UniRefMemberImpl
implements UniRefRepresentativeMember {
    private Sequence sequence = DefaultUniRefFactory.getInstance().buildSequence();

    @Override
    @IndexThisField
    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public void setSequence(Sequence sequence) {
        if (sequence == null || !(sequence instanceof SequenceImpl)) {
            throw new IllegalArgumentException("Please set a non-null sequence");
        }
        this.sequence = sequence;
    }

    public String getRepresentativeMemberAccession() {
        if (this.getUniProtAccessions().size() > 0) {
            return this.getUniProtAccessions().get(0).getValue();
        }
        return "";
    }

    @IndexThisField(fieldName={IndexField.UNIREF_DESCRIPTION}, includeInContent=true)
    public String getRepresentativeDescription() {
        return this.getProteinName().getValue();
    }

    @IndexThisField(fieldName={IndexField.UNIREF_ORGANISM}, includeInContent=true)
    public String getRepresentativeOrganism() {
        return this.getSourceOrganism().getValue();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniRefRepresentativeMemberImpl that = (UniRefRepresentativeMemberImpl)o;
        return this.sequence.equals(that.sequence);
    }

    @Override
    public int hashCode() {
        return this.sequence.hashCode();
    }
}

