/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniref.member;

import uk.ac.ebi.kraken.interfaces.uniref.member.OverlapRegion;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.common.ValueImpl;

public class OverlapRegionImpl
extends ValueImpl
implements OverlapRegion {
    private int start = -1;
    private int end = -1;

    public OverlapRegionImpl() {
        this.value = "";
    }

    @Override
    public void setPosition(int start, int end) {
        if (start < 0 || end < 0 || end < start) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        this.end = end;
        this.createValue();
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    @IndexThisField(includeInContent=true)
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value.equals("")) {
            this.start = -1;
            this.end = -1;
            this.value = "";
            return;
        }
        int index = value.indexOf(45);
        if (index < 1) {
            throw new IllegalArgumentException();
        }
        String startString = value.substring(0, index);
        String endString = value.substring(index + 1);
        try {
            this.start = Integer.parseInt(startString);
            this.end = Integer.parseInt(endString);
        }
        catch (NumberFormatException e) {
            this.start = -1;
            this.end = -1;
            throw new IllegalArgumentException();
        }
        if (this.start > this.end) {
            this.start = -1;
            this.end = -1;
            throw new IllegalArgumentException();
        }
        this.createValue();
    }

    private void createValue() {
        this.value = this.start >= 0 && this.end >= 0 && this.end >= this.start ? this.start + "-" + this.end : "";
    }
}

