/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniref;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabase;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntryId;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntryName;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefMember;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefRepresentativeMember;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.kraken.model.serialize.DefaultUniRefEntryImplSerializer;
import uk.ac.ebi.kraken.model.serialize.UniRefEntryImplSerializer;
import uk.ac.ebi.kraken.util.IndexField;
import uk.ac.ebi.kraken.util.NoNullElementsList;

public class UniRefEntryImpl
implements UniRefEntry,
PersistentObject,
Externalizable {
    public static final int serialVersionUID = 1;
    private long hid;
    private UniRefEntryId uniRefEntryId;
    private Date lastUpdate;
    private UniRefEntryName uniRefEntryName;
    private UniRefDatabase uniRefDatabase;
    private UniRefRepresentativeMember repMember;
    private List<UniRefMember> listMembers;
    private UniRefEntryImplSerializer serializer = new DefaultUniRefEntryImplSerializer();

    public UniRefEntryImpl() {
        this.lastUpdate = new Date();
        this.listMembers = new NoNullElementsList<UniRefMember>(new ArrayList());
        DefaultUniRefFactory factory = DefaultUniRefFactory.getInstance();
        this.uniRefEntryId = factory.buildUniRefEntryId();
        this.uniRefEntryName = factory.buildUniRefEntryName();
        this.uniRefDatabase = factory.buildUniRefDatabase();
        this.repMember = factory.buildUniRefRepresentativeMember();
    }

    @Override
    @IndexThisField
    public UniRefRepresentativeMember getRepresentativeMember() {
        return this.repMember;
    }

    @Override
    public void setRepresentativeMember(UniRefRepresentativeMember representativeMember) {
        if (representativeMember == null) {
            throw new IllegalArgumentException("Please set a non null value into the RepMember");
        }
        this.repMember = representativeMember;
    }

    @Override
    @IndexThisField
    public UniRefDatabase getUniRefDatabase() {
        return this.uniRefDatabase;
    }

    @Override
    public void setUniRefDatabase(UniRefDatabase db) {
        if (db == null) {
            throw new IllegalArgumentException("Please set a non-null database into the UniRefDatabase");
        }
        this.uniRefDatabase = db;
    }

    @Override
    @IndexThisField(fieldName={IndexField.UNIREF_ACCESSION}, includeInContent=true)
    public UniRefEntryId getUniRefEntryId() {
        return this.uniRefEntryId;
    }

    @Override
    public void setUniRefEntryId(UniRefEntryId id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.uniRefEntryId = id;
    }

    @Override
    @IndexThisField(includeInContent=true)
    public Date getUpdate() {
        return this.lastUpdate;
    }

    @IndexThisField(fieldName={IndexField.UNIREF_MEMBER_NUMBER})
    public int getNumberOfMember() {
        int number = 0;
        if (this.repMember != null) {
            ++number;
        }
        if (this.listMembers.size() > 0) {
            number += this.listMembers.size();
        }
        return number;
    }

    @Override
    public void setUpdate(Date lastUpdate) {
        if (lastUpdate == null) {
            throw new IllegalArgumentException("Please set a non-null date into the update");
        }
        this.lastUpdate = lastUpdate;
    }

    @Override
    @IndexThisField(includeInContent=true)
    public UniRefEntryName getName() {
        return this.uniRefEntryName;
    }

    @Override
    public void setName(UniRefEntryName name) {
        if (name == null) {
            throw new IllegalArgumentException("Please set a non-null name into the EntryName");
        }
        this.uniRefEntryName = name;
    }

    @Override
    @IndexThisField
    public List<UniRefMember> getMembers() {
        return this.listMembers;
    }

    @Override
    public void setMembers(List<UniRefMember> members) {
        if (this.listMembers == null) {
            throw new IllegalArgumentException("Please set a non-null list into the members");
        }
        this.listMembers = members;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniRefEntryImpl that = (UniRefEntryImpl)o;
        if (!this.lastUpdate.equals(that.lastUpdate)) {
            return false;
        }
        if (!((Object)this.listMembers).equals(that.listMembers)) {
            return false;
        }
        if (!this.repMember.equals(that.repMember)) {
            return false;
        }
        if (!this.uniRefDatabase.equals(that.uniRefDatabase)) {
            return false;
        }
        if (!this.uniRefEntryId.equals(that.uniRefEntryId)) {
            return false;
        }
        return this.uniRefEntryName.equals(that.uniRefEntryName);
    }

    public int hashCode() {
        int result = this.uniRefEntryId.hashCode();
        result = 29 * result + this.lastUpdate.hashCode();
        result = 29 * result + this.uniRefEntryName.hashCode();
        result = 29 * result + this.uniRefDatabase.hashCode();
        result = 29 * result + this.repMember.hashCode();
        result = 29 * result + ((Object)this.listMembers).hashCode();
        return result;
    }

    @Override
    @IndexThisField(fieldName={IndexField.HID})
    public long getId() {
        return this.hid;
    }

    @Override
    public void setId(long id) {
        this.hid = id;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serializer.writeObject(this, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.serializer.readObject(this, in);
    }
}

