/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniref;

import java.util.Date;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabase;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabaseType;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabaseVersion;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.kraken.util.IndexField;

public class UniRefDatabaseImpl
implements UniRefDatabase {
    private Date releaseDate = new Date();
    private UniRefDatabaseVersion uniRefDatabaseVersion = DefaultUniRefFactory.getInstance().buildUniRefDatabaseVersion();
    private UniRefDatabaseType type = UniRefDatabaseType.UniRef100;

    @Override
    public Date getReleaseDate() {
        return this.releaseDate;
    }

    @Override
    public void setReleaseDate(Date date) {
        if (this.releaseDate == null) {
            throw new IllegalArgumentException("Please set a non-null release date");
        }
        this.releaseDate = date;
    }

    @Override
    public UniRefDatabaseVersion getUniRefVersion() {
        return this.uniRefDatabaseVersion;
    }

    @Override
    public void setVersion(UniRefDatabaseVersion version) {
        if (version == null) {
            throw new IllegalArgumentException("Please set a non-null version");
        }
        this.uniRefDatabaseVersion = version;
    }

    @IndexThisField(fieldName={IndexField.UNIREF_IDENTITY})
    public String getIdentity() {
        return this.type.getIdentity();
    }

    @Override
    public UniRefDatabaseType getType() {
        return this.type;
    }

    @Override
    public void setType(UniRefDatabaseType type) {
        if (type == null) {
            throw new IllegalArgumentException("Please set a non null database type");
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniRefDatabaseImpl that = (UniRefDatabaseImpl)o;
        if (!this.releaseDate.equals(that.releaseDate)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.uniRefDatabaseVersion.equals(that.uniRefDatabaseVersion);
    }

    public int hashCode() {
        int result = this.releaseDate.hashCode();
        result = 29 * result + this.uniRefDatabaseVersion.hashCode();
        result = 29 * result + this.type.hashCode();
        return result;
    }
}

