/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.util;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarSeqFeature;

public class SplicedSequenceCalculator {
    public static String getSplicedSequence(UniProtEntry entry, String isoformName) {
        String result = entry.getSequence().getValue();
        List apComments = entry.getComments(CommentType.ALTERNATIVE_PRODUCTS);
        for (AlternativeProductsComment comment : apComments) {
            List<AlternativeProductsIsoform> isoforms = comment.getIsoforms();
            for (AlternativeProductsIsoform isoform : isoforms) {
                if (!isoform.getName().getValue().equals(isoformName)) continue;
                List<IsoformSequenceId> sequenceIds = isoform.getSequenceIds();
                ArrayList vsfeatures = new ArrayList(entry.getFeatures(FeatureType.VAR_SEQ));
                for (int iii = vsfeatures.size() - 1; iii > -1; --iii) {
                    VarSeqFeature feature = (VarSeqFeature)vsfeatures.get(iii);
                    String featureID = feature.getFeatureId().getValue();
                    for (IsoformSequenceId isoformSequenceId : sequenceIds) {
                        if (!featureID.equals(isoformSequenceId.getValue())) continue;
                        StringBuilder sb = new StringBuilder();
                        sb.append(result.substring(0, feature.getFeatureLocation().getStart() - 1));
                        if (feature.getAlternativeSequences().size() > 0) {
                            sb.append(feature.getAlternativeSequences().get(0).getValue().replaceAll("\\s*", ""));
                        }
                        sb.append(result.substring(feature.getFeatureLocation().getEnd()));
                        result = sb.toString();
                    }
                }
                return result;
            }
        }
        return "";
    }

    public static String getSplicedSequenceForIsoId(UniProtEntry entry, String isoformId) {
        String result = entry.getSequence().getValue();
        List apComments = entry.getComments(CommentType.ALTERNATIVE_PRODUCTS);
        for (AlternativeProductsComment comment : apComments) {
            List<AlternativeProductsIsoform> isoforms = comment.getIsoforms();
            for (AlternativeProductsIsoform isoform : isoforms) {
                String value = isoform.getIds().get(0).getValue();
                if (!value.trim().equalsIgnoreCase(isoformId)) continue;
                List<IsoformSequenceId> sequenceIds = isoform.getSequenceIds();
                ArrayList vsfeatures = new ArrayList(entry.getFeatures(FeatureType.VAR_SEQ));
                for (int iii = vsfeatures.size() - 1; iii > -1; --iii) {
                    VarSeqFeature feature = (VarSeqFeature)vsfeatures.get(iii);
                    String featureID = feature.getFeatureId().getValue();
                    for (IsoformSequenceId isoformSequenceId : sequenceIds) {
                        if (!featureID.equals(isoformSequenceId.getValue())) continue;
                        StringBuilder sb = new StringBuilder();
                        sb.append(result.substring(0, feature.getFeatureLocation().getStart() - 1));
                        if (feature.getAlternativeSequences().size() > 0) {
                            sb.append(feature.getAlternativeSequences().get(0).getValue().replaceAll("\\s*", ""));
                        }
                        sb.append(result.substring(feature.getFeatureLocation().getEnd()));
                        result = sb.toString();
                    }
                }
                return result;
            }
        }
        return "";
    }
}

