/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.organism;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.annotations.Stable;
import uk.ac.ebi.kraken.interfaces.uniprot.Organism;
import uk.ac.ebi.kraken.interfaces.uniprot.organism.OrganismCommonName;
import uk.ac.ebi.kraken.interfaces.uniprot.organism.OrganismName;
import uk.ac.ebi.kraken.interfaces.uniprot.organism.OrganismScientificName;
import uk.ac.ebi.kraken.interfaces.uniprot.organism.OrganismSynonym;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.util.IndexField;
import uk.ac.ebi.kraken.util.test.NullAble;

public class OrganismImpl
implements Organism,
PersistentObject {
    private OrganismScientificName scientificName = DefaultUniProtFactory.getInstance().buildOrganismScientificName();
    private OrganismSynonym synonym = DefaultUniProtFactory.getInstance().buildOrganismSynonym();
    private OrganismCommonName commonName = DefaultUniProtFactory.getInstance().buildOrganismCommonName();
    private long id;

    public OrganismImpl() {
    }

    public OrganismImpl(Organism copy) {
        if (copy.getScientificName() != null) {
            this.scientificName = DefaultUniProtFactory.getInstance().buildOrganismScientificName(copy.getScientificName());
        }
        if (copy.getSynonym() != null) {
            this.synonym = DefaultUniProtFactory.getInstance().buildOrganismSynonym(copy.getSynonym());
        }
        if (copy.getCommonName() != null) {
            this.commonName = DefaultUniProtFactory.getInstance().buildOrganismCommonName(copy.getCommonName());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    @NullAble
    public void setScientificName(OrganismScientificName name) {
        this.scientificName = name;
    }

    @Override
    @IndexThisField(fieldName={IndexField.ORGANISM_SPECIFIC, IndexField.ORGANISM_NAMES, IndexField.ORGANISM_SCIENTIFIC})
    public OrganismScientificName getScientificName() {
        return this.scientificName;
    }

    @Override
    @NullAble
    public void setSynonym(OrganismSynonym name) {
        this.synonym = name;
    }

    @Override
    @IndexThisField(fieldName={IndexField.ORGANISM_SPECIFIC, IndexField.ORGANISM_NAMES, IndexField.ORGANISM_SYNONYM})
    public OrganismSynonym getSynonym() {
        return this.synonym;
    }

    @Override
    public boolean hasSynonym() {
        if (this.synonym == null) {
            return false;
        }
        return !this.synonym.getValue().equals("");
    }

    @Override
    @NullAble
    public void setCommonName(OrganismCommonName name) {
        this.commonName = name;
    }

    @Override
    @IndexThisField(fieldName={IndexField.ORGANISM_SPECIFIC, IndexField.ORGANISM_NAMES, IndexField.ORGANISM_COMMON})
    public OrganismCommonName getCommonName() {
        return this.commonName;
    }

    @Override
    public boolean hasCommonName() {
        if (this.commonName == null) {
            return false;
        }
        return !this.commonName.getValue().equals("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganismImpl organism = (OrganismImpl)o;
        if (this.id != organism.id) {
            return false;
        }
        if (this.commonName != null ? !this.commonName.equals(organism.commonName) : organism.commonName != null) {
            return false;
        }
        if (this.scientificName != null ? !this.scientificName.equals(organism.scientificName) : organism.scientificName != null) {
            return false;
        }
        return !(this.synonym != null ? !this.synonym.equals(organism.synonym) : organism.synonym != null);
    }

    public int hashCode() {
        int result = this.scientificName != null ? this.scientificName.hashCode() : 0;
        result = 29 * result + (this.synonym != null ? this.synonym.hashCode() : 0);
        result = 29 * result + (this.commonName != null ? this.commonName.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        String result = "";
        result = this.getScientificName().getValue();
        if (this.hasCommonName()) {
            result = result + " (" + this.getCommonName().getValue() + ")";
        }
        if (this.hasSynonym()) {
            result = result + " (" + this.getSynonym().getValue() + ")";
        }
        return result;
    }

    @Override
    @Stable
    public List<OrganismName> getOrganismNames() {
        ArrayList<OrganismName> result = new ArrayList<OrganismName>();
        result.add(this.scientificName);
        if (this.hasCommonName()) {
            result.add(this.commonName);
        }
        if (this.hasSynonym()) {
            result.add(this.synonym);
        }
        return result;
    }
}

