/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.genename;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.GeneName;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.GeneNameSynonym;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.ORFName;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.OrderedLocusName;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.util.IndexField;

public class GeneImpl
implements Gene,
PersistentObject {
    private GeneName geneName = DefaultUniProtFactory.getInstance().buildGeneName();
    private List<GeneNameSynonym> geneNameSynonyms;
    private List<OrderedLocusName> orderedLocusNames;
    private List<ORFName> orfNames;
    private long id;

    public GeneImpl() {
        this.geneNameSynonyms = new ArrayList<GeneNameSynonym>();
        this.orderedLocusNames = new ArrayList<OrderedLocusName>();
        this.orfNames = new ArrayList<ORFName>();
    }

    public GeneImpl(Gene copy) {
        this.geneName.setValue(copy.getGeneName().getValue());
        this.geneNameSynonyms = new ArrayList<GeneNameSynonym>();
        for (GeneNameSynonym syn : copy.getGeneNameSynonyms()) {
            GeneNameSynonym copysyn = DefaultUniProtFactory.getInstance().buildGeneNameSynonym();
            copysyn.setValue(syn.getValue());
            this.geneNameSynonyms.add(copysyn);
        }
        this.orderedLocusNames = new ArrayList<OrderedLocusName>();
        for (OrderedLocusName loc : copy.getOrderedLocusNames()) {
            OrderedLocusName copyLoc = DefaultUniProtFactory.getInstance().buildOrderedLocusName();
            copyLoc.setValue(loc.getValue());
            this.orderedLocusNames.add(copyLoc);
        }
        this.orfNames = new ArrayList<ORFName>();
        for (ORFName name : copy.getORFNames()) {
            ORFName copyName = DefaultUniProtFactory.getInstance().buildORFName();
            copyName.setValue(name.getValue());
            this.orfNames.add(copyName);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean hasGeneName() {
        if (this.geneName == null) {
            return false;
        }
        return !this.geneName.getValue().equals("");
    }

    @Override
    @IndexThisField(fieldName={IndexField.GENE_ANNOTATION, IndexField.NAME_ANNOTATION, IndexField.GENE_NAME, IndexField.GENE_NAME_EXACT, IndexField.GENE_EXACT})
    public GeneName getGeneName() {
        return this.geneName;
    }

    @Override
    public void setGeneName(GeneName geneName) {
        if (geneName == null) {
            throw new IllegalArgumentException();
        }
        this.geneName = geneName;
    }

    @Override
    @IndexThisField(fieldName={IndexField.GENE_ANNOTATION, IndexField.GENE_SYNONYM, IndexField.GENE_SYNONYM_EXACT, IndexField.GENE_EXACT})
    public List<GeneNameSynonym> getGeneNameSynonyms() {
        return this.geneNameSynonyms;
    }

    @Override
    public void setGeneNameSynonyms(List<GeneNameSynonym> synonyms) {
        if (synonyms == null) {
            throw new IllegalArgumentException();
        }
        this.geneNameSynonyms = synonyms;
    }

    @Override
    @IndexThisField(fieldName={IndexField.GENE_ANNOTATION, IndexField.GENE_ORDERED_LOCUS, IndexField.GENE_EXACT})
    public List<OrderedLocusName> getOrderedLocusNames() {
        return this.orderedLocusNames;
    }

    @Override
    public void setOrderedLocusNames(List<OrderedLocusName> orderedLocusNames) {
        if (orderedLocusNames == null) {
            throw new IllegalArgumentException();
        }
        this.orderedLocusNames = orderedLocusNames;
    }

    @Override
    @IndexThisField(fieldName={IndexField.GENE_ANNOTATION, IndexField.GENE_ORF, IndexField.GENE_EXACT})
    public List<ORFName> getORFNames() {
        return this.orfNames;
    }

    @Override
    public void setORFNames(List<ORFName> orfNames) {
        if (orfNames == null) {
            throw new IllegalArgumentException();
        }
        this.orfNames = orfNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneImpl gene = (GeneImpl)o;
        if (this.geneName != null ? !this.geneName.equals(gene.geneName) : gene.geneName != null) {
            return false;
        }
        if (this.geneNameSynonyms != null ? !((Object)this.geneNameSynonyms).equals(gene.geneNameSynonyms) : gene.geneNameSynonyms != null) {
            return false;
        }
        if (this.orderedLocusNames != null ? !((Object)this.orderedLocusNames).equals(gene.orderedLocusNames) : gene.orderedLocusNames != null) {
            return false;
        }
        return !(this.orfNames != null ? !((Object)this.orfNames).equals(gene.orfNames) : gene.orfNames != null);
    }

    public int hashCode() {
        int result = this.geneName != null ? this.geneName.hashCode() : 0;
        result = 29 * result + (this.geneNameSynonyms != null ? ((Object)this.geneNameSynonyms).hashCode() : 0);
        result = 29 * result + (this.orderedLocusNames != null ? ((Object)this.orderedLocusNames).hashCode() : 0);
        result = 29 * result + (this.orfNames != null ? ((Object)this.orfNames).hashCode() : 0);
        return result;
    }
}

