/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.features;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureSequence;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarSeqFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarsplicIsoform;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.model.uniprot.features.FeatureImpl;
import uk.ac.ebi.kraken.util.NoNullElementsList;
import uk.ac.ebi.kraken.util.test.NullAble;

public class VarSeqFeatureImpl
extends FeatureImpl
implements VarSeqFeature {
    private List<VarsplicIsoform> varsplicIsoforms;
    private FeatureSequence originalSequence;
    private List<FeatureSequence> alternativeSequences;
    private FeatureId featureId = DefaultFeatureFactory.getInstance().buildFeatureId("");

    public VarSeqFeatureImpl(VarSeqFeature feature) {
        super(feature);
        this.originalSequence = DefaultFeatureFactory.getInstance().buildFeatureSequence();
        this.alternativeSequences = new NoNullElementsList<FeatureSequence>(new ArrayList());
        this.varsplicIsoforms = new NoNullElementsList<VarsplicIsoform>(new ArrayList());
        if (feature.getFeatureId() != null) {
            this.featureId = DefaultFeatureFactory.getInstance().buildFeatureId(feature.getFeatureId().getValue());
        }
        this.varsplicIsoforms = new NoNullElementsList<VarsplicIsoform>(new ArrayList());
        if (feature.getVarsplicIsoforms() != null) {
            for (VarsplicIsoform isoform : feature.getVarsplicIsoforms()) {
                this.varsplicIsoforms.add(DefaultFeatureFactory.getInstance().buildVarsplicIsoform(isoform.getValue()));
            }
        }
        if (feature.getOriginalSequence() != null) {
            this.originalSequence = DefaultFeatureFactory.getInstance().buildFeatureSequence(feature.getOriginalSequence().getValue());
        }
        this.alternativeSequences = new NoNullElementsList<FeatureSequence>(new ArrayList());
        if (feature.getAlternativeSequences() != null) {
            for (FeatureSequence seq : feature.getAlternativeSequences()) {
                this.alternativeSequences.add(DefaultFeatureFactory.getInstance().buildFeatureSequence(seq.getValue()));
            }
        }
    }

    public VarSeqFeatureImpl() {
        this.originalSequence = DefaultFeatureFactory.getInstance().buildFeatureSequence();
        this.alternativeSequences = new ArrayList<FeatureSequence>();
        this.varsplicIsoforms = new ArrayList<VarsplicIsoform>();
    }

    @Override
    public boolean hasFeatureId() {
        if (this.featureId == null) {
            return false;
        }
        return !this.featureId.getValue().equals("");
    }

    @Override
    public FeatureType getType() {
        return FeatureType.VAR_SEQ;
    }

    @Override
    public FeatureSequence getOriginalSequence() {
        return this.originalSequence;
    }

    @Override
    @NullAble
    public void setOriginalSequence(FeatureSequence original) {
        this.originalSequence = original;
    }

    @Override
    public List<FeatureSequence> getAlternativeSequences() {
        return this.alternativeSequences;
    }

    @Override
    @NullAble
    public void setAlternativeSequences(List<FeatureSequence> alternative) {
        this.alternativeSequences = alternative;
    }

    @Override
    public FeatureId getFeatureId() {
        return this.featureId;
    }

    @Override
    @NullAble
    public void setFeatureId(FeatureId id) {
        this.featureId = id;
    }

    @Override
    public List<VarsplicIsoform> getVarsplicIsoforms() {
        return this.varsplicIsoforms;
    }

    @Override
    @NullAble
    public void setVarsplicIsoforms(List<VarsplicIsoform> isoforms) {
        this.varsplicIsoforms = isoforms;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VarSeqFeatureImpl that = (VarSeqFeatureImpl)o;
        if (this.alternativeSequences != null ? !((Object)this.alternativeSequences).equals(that.alternativeSequences) : that.alternativeSequences != null) {
            return false;
        }
        if (this.featureId != null ? !this.featureId.equals(that.featureId) : that.featureId != null) {
            return false;
        }
        if (this.originalSequence != null ? !this.originalSequence.equals(that.originalSequence) : that.originalSequence != null) {
            return false;
        }
        return !(this.varsplicIsoforms != null ? !((Object)this.varsplicIsoforms).equals(that.varsplicIsoforms) : that.varsplicIsoforms != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.varsplicIsoforms != null ? ((Object)this.varsplicIsoforms).hashCode() : 0);
        result = 29 * result + (this.originalSequence != null ? this.originalSequence.hashCode() : 0);
        result = 29 * result + (this.alternativeSequences != null ? ((Object)this.alternativeSequences).hashCode() : 0);
        result = 29 * result + (this.featureId != null ? this.featureId.hashCode() : 0);
        return result;
    }
}

