/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.features;

import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocationModifier;

public class FeatureLocationImpl
implements FeatureLocation {
    private FeatureLocationModifier startModifier;
    private FeatureLocationModifier endModifier;
    private int start;
    private int end;

    public FeatureLocationImpl() {
        this.start = -1;
        this.end = -1;
        this.startModifier = FeatureLocationModifier.UNKOWN;
        this.endModifier = FeatureLocationModifier.UNKOWN;
    }

    public FeatureLocationImpl(FeatureLocation copy) {
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        this.start = copy.getStart();
        this.startModifier = copy.getStartModifier();
        this.end = copy.getEnd();
        this.endModifier = copy.getEndModifier();
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public FeatureLocationModifier getStartModifier() {
        return this.startModifier;
    }

    @Override
    public FeatureLocationModifier getEndModifier() {
        return this.endModifier;
    }

    @Override
    public void setStartModifier(FeatureLocationModifier modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException();
        }
        this.startModifier = modifier;
    }

    @Override
    public void setEndModifier(FeatureLocationModifier modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException();
        }
        this.endModifier = modifier;
    }

    @Override
    public boolean isStartAvailable() {
        return this.start != -1;
    }

    @Override
    public boolean isEndAvailable() {
        return this.end != -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FeatureLocationImpl)) {
            return false;
        }
        FeatureLocationImpl featureLocation = (FeatureLocationImpl)o;
        if (this.end != featureLocation.end) {
            return false;
        }
        if (this.start != featureLocation.start) {
            return false;
        }
        if (!this.endModifier.equals((Object)featureLocation.endModifier)) {
            return false;
        }
        return this.startModifier.equals((Object)featureLocation.startModifier);
    }

    public int hashCode() {
        int result = this.startModifier.hashCode();
        result = 29 * result + this.endModifier.hashCode();
        result = 29 * result + this.start;
        result = 29 * result + this.end;
        return result;
    }

    public String toString() {
        return "[startModifier=" + (Object)((Object)this.startModifier) + ", endModifier=" + (Object)((Object)this.endModifier) + ", start=" + this.start + ", end=" + this.end + "]";
    }
}

