/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.features;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.model.uniprot.features.FeatureLocationImpl;
import uk.ac.ebi.kraken.util.NoNullElementsList;
import uk.ac.ebi.kraken.util.test.NullAble;

public abstract class FeatureImpl
implements Feature,
PersistentObject {
    protected FeatureLocation featureLocation;
    private FeatureStatus featureStatus;
    private List<EvidenceId> evidenceIds;
    private long id;

    public FeatureImpl() {
        this.featureLocation = new FeatureLocationImpl();
        this.featureStatus = FeatureStatus.EXPERIMENTAL;
    }

    public FeatureImpl(Feature feature) {
        if (feature == null) {
            throw new IllegalArgumentException();
        }
        this.featureLocation = DefaultFeatureFactory.getInstance().buildFeatureLocation(feature.getFeatureLocation().getStart(), feature.getFeatureLocation().getStartModifier(), feature.getFeatureLocation().getEnd(), feature.getFeatureLocation().getEndModifier());
        this.evidenceIds = new NoNullElementsList<EvidenceId>(new ArrayList());
        for (EvidenceId evidenceId : feature.getEvidenceIds()) {
            this.evidenceIds.add(DefaultEvidenceFactory.getInstance().buildEvidenceId(evidenceId.getValue()));
        }
        if (feature.getFeatureStatus() != null) {
            this.featureStatus = feature.getFeatureStatus();
        }
    }

    @Override
    public abstract FeatureType getType();

    private void setType(FeatureType type) {
    }

    @Override
    public FeatureStatus getFeatureStatus() {
        return this.featureStatus;
    }

    @Override
    public void setFeatureStatus(FeatureStatus featureStatus) {
        if (featureStatus == null) {
            throw new IllegalArgumentException();
        }
        this.featureStatus = featureStatus;
    }

    @Override
    public FeatureLocation getFeatureLocation() {
        return this.featureLocation;
    }

    @Override
    @NullAble
    public void setFeatureLocation(FeatureLocation featureLocation) {
        if (featureLocation == null) {
            throw new IllegalArgumentException();
        }
        this.featureLocation = featureLocation;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        if (this.evidenceIds == null) {
            this.evidenceIds = new ArrayList<EvidenceId>();
        }
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidenceIds) {
        this.evidenceIds = evidenceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureImpl feature = (FeatureImpl)o;
        if (this.id != feature.id) {
            return false;
        }
        if (this.evidenceIds != null && this.evidenceIds.size() > 0 ? !((Object)this.evidenceIds).equals(feature.evidenceIds) : feature.evidenceIds != null && feature.evidenceIds.size() > 0) {
            return false;
        }
        if (this.featureLocation != null ? !this.featureLocation.equals(feature.featureLocation) : feature.featureLocation != null) {
            return false;
        }
        return this.featureStatus == feature.featureStatus;
    }

    public int hashCode() {
        int result = this.featureLocation != null ? this.featureLocation.hashCode() : 0;
        result = 31 * result + (this.evidenceIds != null && this.evidenceIds.size() > 0 ? ((Object)this.evidenceIds).hashCode() : 0);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.featureStatus != null ? this.featureStatus.hashCode() : 0);
        return result;
    }
}

