/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.evidences;

import java.util.Date;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.Evidence;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceAttribute;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceCategory;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceCode;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceOriginName;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;

public class EvidenceImpl
implements PersistentObject,
Evidence {
    private long id;
    private EvidenceId evidenceId;
    private EvidenceCategory category;
    private EvidenceType type;
    private EvidenceOriginName originName;
    private EvidenceAttribute attribute;
    private EvidenceCode code;
    private Date date;

    public EvidenceImpl() {
        this.evidenceId = DefaultEvidenceFactory.getInstance().buildEvidenceId();
        this.category = EvidenceCategory.NOT_SPECIFIED;
        this.type = EvidenceType.NOT_SPECIFIED;
        this.originName = DefaultEvidenceFactory.getInstance().buildEvidenceOriginName();
        this.attribute = DefaultEvidenceFactory.getInstance().buildEvidenceAttribute();
        this.code = EvidenceCode.NOT_SPECIFIED;
        this.date = new Date(0L);
    }

    public EvidenceImpl(Evidence copy) {
        this.evidenceId = DefaultEvidenceFactory.getInstance().buildEvidenceId(copy.getEvidenceId().getValue());
        this.category = copy.getCategory();
        this.type = copy.getType();
        this.originName = DefaultEvidenceFactory.getInstance().buildEvidenceOriginName(copy.getOriginName().getValue());
        this.attribute = DefaultEvidenceFactory.getInstance().buildEvidenceAttribute(copy.getAttribute().getValue());
        this.code = copy.getEvidenceCode();
        this.date = new Date(copy.getDate().getTime());
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public EvidenceAttribute getAttribute() {
        return this.attribute;
    }

    @Override
    public void setAttribute(EvidenceAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException();
        }
        this.attribute = attribute;
    }

    @Override
    public EvidenceCategory getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(EvidenceCategory category) {
        if (category == null) {
            throw new IllegalArgumentException();
        }
        this.category = category;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setEvidenceCode(EvidenceCode evidenceCode) {
        this.code = evidenceCode;
    }

    @Override
    public EvidenceCode getEvidenceCode() {
        return this.code;
    }

    @Override
    public void setDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException();
        }
        this.date = date;
    }

    @Override
    public EvidenceId getEvidenceId() {
        return this.evidenceId;
    }

    @Override
    public void setEvidenceId(EvidenceId evidenceId) {
        if (evidenceId == null) {
            throw new IllegalArgumentException();
        }
        this.evidenceId = evidenceId;
    }

    @Override
    public EvidenceOriginName getOriginName() {
        return this.originName;
    }

    @Override
    public void setOriginName(EvidenceOriginName originName) {
        if (originName == null) {
            throw new IllegalArgumentException();
        }
        this.originName = originName;
    }

    @Override
    public EvidenceType getType() {
        return this.type;
    }

    @Override
    public void setType(EvidenceType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvidenceImpl evidence = (EvidenceImpl)o;
        if (!this.attribute.equals(evidence.attribute)) {
            return false;
        }
        if (this.category != evidence.category) {
            return false;
        }
        if (!this.date.equals(evidence.date)) {
            return false;
        }
        if (!this.evidenceId.equals(evidence.evidenceId)) {
            return false;
        }
        if (!this.originName.equals(evidence.originName)) {
            return false;
        }
        if (this.type != evidence.type) {
            return false;
        }
        return this.code == evidence.code;
    }

    public int hashCode() {
        int result = this.evidenceId.hashCode();
        result = 29 * result + this.category.hashCode();
        result = 29 * result + this.type.hashCode();
        result = 29 * result + this.originName.hashCode();
        result = 29 * result + this.attribute.hashCode();
        result = 29 * result + this.code.hashCode();
        result = 29 * result + this.date.hashCode();
        return result;
    }

    public String toString() {
        return "EvidenceImpl{attribute=" + this.attribute + ", category=" + (Object)((Object)this.category) + ", date=" + this.date + ", evidenceId=" + this.evidenceId + ", originName=" + this.originName + ", code=" + (Object)((Object)this.code) + ", type=" + (Object)((Object)this.type) + '}';
    }
}

