/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.description;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.annotations.Stable;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class SectionImpl
implements Section {
    private List<Name> names = new ArrayList<Name>();
    private List<EvidenceId> evidenceIds = new ArrayList<EvidenceId>();

    public SectionImpl() {
    }

    public SectionImpl(Section that) {
        this();
        for (Name names : that.getNames()) {
            this.names.add(DefaultUniProtFactory.getInstance().buildName(names));
        }
        this.evidenceIds = new ArrayList<EvidenceId>();
        for (EvidenceId evidenceId : that.getEvidenceIds()) {
            this.evidenceIds.add(DefaultUniProtFactory.getInstance().buildEvidenceId(evidenceId));
        }
    }

    @Override
    public List<Name> getNames() {
        return this.names;
    }

    @Override
    public void setNames(List<Name> names) {
        this.names = names;
    }

    @Override
    public List<Name> getNamesByType(NameType type) {
        ArrayList<Name> nameList = new ArrayList<Name>();
        for (Name name : this.names) {
            if (name.getNameType() != type) continue;
            nameList.add(name);
        }
        return nameList;
    }

    @Override
    @Stable
    public List<EvidenceId> getEvidenceIds() {
        return this.evidenceIds;
    }

    @Override
    @Stable
    public void setEvidenceIds(List<EvidenceId> evidences) {
        this.evidenceIds = evidences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SectionImpl section = (SectionImpl)o;
        if (this.evidenceIds != null ? !((Object)this.evidenceIds).equals(section.evidenceIds) : section.evidenceIds != null) {
            return false;
        }
        return !(this.names != null ? !((Object)this.names).equals(section.names) : section.names != null);
    }

    public int hashCode() {
        int result = this.names != null ? ((Object)this.names).hashCode() : 0;
        result = 31 * result + (this.evidenceIds != null ? ((Object)this.evidenceIds).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Section: " + this.names.toString();
    }
}

