/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.zfin;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.zfin.Zfin;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.zfin.ZfinAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.zfin.ZfinDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class ZfinImpl
extends DatabaseCrossReferenceImpl
implements Zfin,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.ZFIN;
    private long id = 0L;
    private ZfinAccessionNumber zfinAccessionNumber = DefaultXRefFactory.getInstance().buildZfinAccessionNumber("");
    private ZfinDescription zfinDescription = DefaultXRefFactory.getInstance().buildZfinDescription("");

    public ZfinImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getZfinAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public ZfinImpl(ZfinImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasZfinAccessionNumber()) {
            this.setZfinAccessionNumber(toCopy.getZfinAccessionNumber());
        }
        if (toCopy.hasZfinDescription()) {
            this.setZfinDescription(toCopy.getZfinDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ZfinImpl)) {
            return false;
        }
        ZfinImpl myClass = (ZfinImpl)o;
        if (!this.zfinAccessionNumber.equals(myClass.getZfinAccessionNumber())) {
            return false;
        }
        return this.zfinDescription.equals(myClass.getZfinDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.zfinAccessionNumber != null ? this.zfinAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.zfinDescription != null ? this.zfinDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.zfinAccessionNumber + ":" + this.zfinDescription + ";";
    }

    @Override
    public ZfinAccessionNumber getZfinAccessionNumber() {
        return this.zfinAccessionNumber;
    }

    @Override
    public void setZfinAccessionNumber(ZfinAccessionNumber zfinAccessionNumber) {
        if (zfinAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.zfinAccessionNumber = zfinAccessionNumber;
    }

    @Override
    public boolean hasZfinAccessionNumber() {
        return !this.zfinAccessionNumber.getValue().equals("");
    }

    @Override
    public ZfinDescription getZfinDescription() {
        return this.zfinDescription;
    }

    @Override
    public void setZfinDescription(ZfinDescription zfinDescription) {
        if (zfinDescription == null) {
            throw new IllegalArgumentException();
        }
        this.zfinDescription = zfinDescription;
    }

    @Override
    public boolean hasZfinDescription() {
        return !this.zfinDescription.getValue().equals("");
    }
}

