/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.yepd;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.yepd.Yepd;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.yepd.YepdAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.yepd.YepdDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class YepdImpl
extends DatabaseCrossReferenceImpl
implements Yepd,
PersistentObject {
    private DatabaseType databaseType = DatabaseType.YEPD;
    private long id = 0L;
    private YepdAccessionNumber yepdAccessionNumber = DefaultXRefFactory.getInstance().buildYepdAccessionNumber("");
    private YepdDescription yepdDescription = DefaultXRefFactory.getInstance().buildYepdDescription("");

    public YepdImpl() {
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public YepdImpl(YepdImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasYepdAccessionNumber()) {
            this.setYepdAccessionNumber(toCopy.getYepdAccessionNumber());
        }
        if (toCopy.hasYepdDescription()) {
            this.setYepdDescription(toCopy.getYepdDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof YepdImpl)) {
            return false;
        }
        YepdImpl myClass = (YepdImpl)o;
        if (!this.yepdAccessionNumber.equals(myClass.getYepdAccessionNumber())) {
            return false;
        }
        return this.yepdDescription.equals(myClass.getYepdDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.yepdAccessionNumber != null ? this.yepdAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.yepdDescription != null ? this.yepdDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.yepdAccessionNumber + ":" + this.yepdDescription + ";";
    }

    @Override
    public YepdAccessionNumber getYepdAccessionNumber() {
        return this.yepdAccessionNumber;
    }

    @Override
    public void setYepdAccessionNumber(YepdAccessionNumber yepdAccessionNumber) {
        if (yepdAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.yepdAccessionNumber = yepdAccessionNumber;
    }

    @Override
    public boolean hasYepdAccessionNumber() {
        return !this.yepdAccessionNumber.getValue().equals("");
    }

    @Override
    public YepdDescription getYepdDescription() {
        return this.yepdDescription;
    }

    @Override
    public void setYepdDescription(YepdDescription yepdDescription) {
        if (yepdDescription == null) {
            throw new IllegalArgumentException();
        }
        this.yepdDescription = yepdDescription;
    }

    @Override
    public boolean hasYepdDescription() {
        return !this.yepdDescription.getValue().equals("");
    }
}

