/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.xenbase;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.xenbase.Xenbase;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.xenbase.XenbaseAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.xenbase.XenbaseGeneName;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class XenbaseImpl
extends DatabaseCrossReferenceImpl
implements Xenbase,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.XENBASE;
    private long id = 0L;
    private XenbaseAccessionNumber xenbaseAccessionNumber = DefaultXRefFactory.getInstance().buildXenbaseAccessionNumber("");
    private XenbaseGeneName xenbaseGeneName = DefaultXRefFactory.getInstance().buildXenbaseGeneName("");

    public XenbaseImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getXenbaseAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public XenbaseImpl(XenbaseImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasXenbaseAccessionNumber()) {
            this.setXenbaseAccessionNumber(toCopy.getXenbaseAccessionNumber());
        }
        if (toCopy.hasXenbaseGeneName()) {
            this.setXenbaseGeneName(toCopy.getXenbaseGeneName());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof XenbaseImpl)) {
            return false;
        }
        XenbaseImpl myClass = (XenbaseImpl)o;
        if (!this.xenbaseAccessionNumber.equals(myClass.getXenbaseAccessionNumber())) {
            return false;
        }
        return this.xenbaseGeneName.equals(myClass.getXenbaseGeneName());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.xenbaseAccessionNumber != null ? this.xenbaseAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.xenbaseGeneName != null ? this.xenbaseGeneName.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.xenbaseAccessionNumber + ":" + this.xenbaseGeneName + ";";
    }

    @Override
    public XenbaseAccessionNumber getXenbaseAccessionNumber() {
        return this.xenbaseAccessionNumber;
    }

    @Override
    public void setXenbaseAccessionNumber(XenbaseAccessionNumber xenbaseAccessionNumber) {
        if (xenbaseAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.xenbaseAccessionNumber = xenbaseAccessionNumber;
    }

    @Override
    public boolean hasXenbaseAccessionNumber() {
        return !this.xenbaseAccessionNumber.getValue().equals("");
    }

    @Override
    public XenbaseGeneName getXenbaseGeneName() {
        return this.xenbaseGeneName;
    }

    @Override
    public void setXenbaseGeneName(XenbaseGeneName xenbaseGeneName) {
        if (xenbaseGeneName == null) {
            throw new IllegalArgumentException();
        }
        this.xenbaseGeneName = xenbaseGeneName;
    }

    @Override
    public boolean hasXenbaseGeneName() {
        return !this.xenbaseGeneName.getValue().equals("");
    }
}

