/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.wormpep;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.wormpep.WormPep;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.wormpep.WormPepAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.wormpep.WormPepDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class WormPepImpl
extends DatabaseCrossReferenceImpl
implements WormPep,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.WORMPEP;
    private long id = 0L;
    private WormPepAccessionNumber wormPepAccessionNumber = DefaultXRefFactory.getInstance().buildWormPepAccessionNumber("");
    private WormPepDescription wormPepDescription = DefaultXRefFactory.getInstance().buildWormPepDescription("");

    public WormPepImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getWormPepAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public WormPepImpl(WormPepImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasWormPepAccessionNumber()) {
            this.setWormPepAccessionNumber(toCopy.getWormPepAccessionNumber());
        }
        if (toCopy.hasWormPepDescription()) {
            this.setWormPepDescription(toCopy.getWormPepDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof WormPepImpl)) {
            return false;
        }
        WormPepImpl myClass = (WormPepImpl)o;
        if (!this.wormPepAccessionNumber.equals(myClass.getWormPepAccessionNumber())) {
            return false;
        }
        return this.wormPepDescription.equals(myClass.getWormPepDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.wormPepAccessionNumber != null ? this.wormPepAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.wormPepDescription != null ? this.wormPepDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.wormPepAccessionNumber + ":" + this.wormPepDescription + ";";
    }

    @Override
    public WormPepAccessionNumber getWormPepAccessionNumber() {
        return this.wormPepAccessionNumber;
    }

    @Override
    public void setWormPepAccessionNumber(WormPepAccessionNumber wormPepAccessionNumber) {
        if (wormPepAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.wormPepAccessionNumber = wormPepAccessionNumber;
    }

    @Override
    public boolean hasWormPepAccessionNumber() {
        return !this.wormPepAccessionNumber.getValue().equals("");
    }

    @Override
    public WormPepDescription getWormPepDescription() {
        return this.wormPepDescription;
    }

    @Override
    public void setWormPepDescription(WormPepDescription wormPepDescription) {
        if (wormPepDescription == null) {
            throw new IllegalArgumentException();
        }
        this.wormPepDescription = wormPepDescription;
    }

    @Override
    public boolean hasWormPepDescription() {
        return !this.wormPepDescription.getValue().equals("");
    }
}

