/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.wormbase;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.wormbase.WormBase;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.wormbase.WormBaseAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.wormbase.WormBaseDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.wormbase.WormBaseGeneIdentifier;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.wormbase.WormBaseProteinIdentifier;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class WormBaseImpl
extends DatabaseCrossReferenceImpl
implements WormBase,
PersistentObject {
    private DatabaseType databaseType = DatabaseType.WORMBASE;
    private long id = 0L;
    private WormBaseAccessionNumber wormBaseAccessionNumber = DefaultXRefFactory.getInstance().buildWormBaseAccessionNumber("");
    private WormBaseProteinIdentifier wormBaseProteinIdentifier = DefaultXRefFactory.getInstance().buildWormBaseProteinIdentifier("");
    private WormBaseGeneIdentifier wormBaseGeneIdentifier = DefaultXRefFactory.getInstance().buildWormBaseGeneIdentifier("");
    private WormBaseDescription wormBaseDescription = DefaultXRefFactory.getInstance().buildWormBaseDescription("");

    public WormBaseImpl() {
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public WormBaseImpl(WormBaseImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasWormBaseAccessionNumber()) {
            this.setWormBaseAccessionNumber(toCopy.getWormBaseAccessionNumber());
        }
        if (toCopy.hasWormBaseProteinIdentifier()) {
            this.setWormBaseProteinIdentifier(toCopy.getWormBaseProteinIdentifier());
        }
        if (toCopy.hasWormBaseGeneIdentifier()) {
            this.setWormBaseGeneIdentifier(toCopy.getWormBaseGeneIdentifier());
        }
        if (toCopy.hasWormBaseDescription()) {
            this.setWormBaseDescription(toCopy.getWormBaseDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof WormBaseImpl)) {
            return false;
        }
        WormBaseImpl myClass = (WormBaseImpl)o;
        if (!this.wormBaseAccessionNumber.equals(myClass.getWormBaseAccessionNumber())) {
            return false;
        }
        if (!this.wormBaseProteinIdentifier.equals(myClass.getWormBaseProteinIdentifier())) {
            return false;
        }
        if (!this.wormBaseGeneIdentifier.equals(myClass.getWormBaseGeneIdentifier())) {
            return false;
        }
        return this.wormBaseDescription.equals(myClass.getWormBaseDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.wormBaseAccessionNumber != null ? this.wormBaseAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.wormBaseProteinIdentifier != null ? this.wormBaseProteinIdentifier.hashCode() : 0);
        result = 29 * result + (this.wormBaseGeneIdentifier != null ? this.wormBaseGeneIdentifier.hashCode() : 0);
        result = 29 * result + (this.wormBaseDescription != null ? this.wormBaseDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.wormBaseAccessionNumber + ":" + this.wormBaseProteinIdentifier + ":" + this.wormBaseGeneIdentifier + ":" + this.wormBaseDescription + ";";
    }

    @Override
    public WormBaseAccessionNumber getWormBaseAccessionNumber() {
        return this.wormBaseAccessionNumber;
    }

    @Override
    public void setWormBaseAccessionNumber(WormBaseAccessionNumber wormBaseAccessionNumber) {
        if (wormBaseAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.wormBaseAccessionNumber = wormBaseAccessionNumber;
    }

    @Override
    public boolean hasWormBaseAccessionNumber() {
        return !this.wormBaseAccessionNumber.getValue().equals("");
    }

    @Override
    public WormBaseProteinIdentifier getWormBaseProteinIdentifier() {
        return this.wormBaseProteinIdentifier;
    }

    @Override
    public void setWormBaseProteinIdentifier(WormBaseProteinIdentifier wormBaseProteinIdentifier) {
        if (wormBaseProteinIdentifier == null) {
            throw new IllegalArgumentException();
        }
        this.wormBaseProteinIdentifier = wormBaseProteinIdentifier;
    }

    @Override
    public boolean hasWormBaseProteinIdentifier() {
        return !this.wormBaseProteinIdentifier.getValue().equals("");
    }

    @Override
    public WormBaseGeneIdentifier getWormBaseGeneIdentifier() {
        return this.wormBaseGeneIdentifier;
    }

    @Override
    public void setWormBaseGeneIdentifier(WormBaseGeneIdentifier wormBaseGeneIdentifier) {
        if (wormBaseGeneIdentifier == null) {
            throw new IllegalArgumentException();
        }
        this.wormBaseGeneIdentifier = wormBaseGeneIdentifier;
    }

    @Override
    public boolean hasWormBaseGeneIdentifier() {
        return !this.wormBaseGeneIdentifier.getValue().equals("");
    }

    @Override
    public WormBaseDescription getWormBaseDescription() {
        return this.wormBaseDescription;
    }

    @Override
    public void setWormBaseDescription(WormBaseDescription wormBaseDescription) {
        if (wormBaseDescription == null) {
            throw new IllegalArgumentException();
        }
        this.wormBaseDescription = wormBaseDescription;
    }

    @Override
    public boolean hasWormBaseDescription() {
        return !this.wormBaseDescription.getValue().equals("");
    }
}

