/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.vectorbase;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.vectorbase.VectorBase;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.vectorbase.VectorBaseAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.vectorbase.VectorBaseDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class VectorBaseImpl
extends DatabaseCrossReferenceImpl
implements VectorBase,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.VECTORBASE;
    private long id = 0L;
    private VectorBaseAccessionNumber vectorBaseAccessionNumber = DefaultXRefFactory.getInstance().buildVectorBaseAccessionNumber("");
    private VectorBaseDescription vectorBaseDescription = DefaultXRefFactory.getInstance().buildVectorBaseDescription("");

    public VectorBaseImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getVectorBaseAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public VectorBaseImpl(VectorBaseImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasVectorBaseAccessionNumber()) {
            this.setVectorBaseAccessionNumber(toCopy.getVectorBaseAccessionNumber());
        }
        if (toCopy.hasVectorBaseDescription()) {
            this.setVectorBaseDescription(toCopy.getVectorBaseDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof VectorBaseImpl)) {
            return false;
        }
        VectorBaseImpl myClass = (VectorBaseImpl)o;
        if (!this.vectorBaseAccessionNumber.equals(myClass.getVectorBaseAccessionNumber())) {
            return false;
        }
        return this.vectorBaseDescription.equals(myClass.getVectorBaseDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.vectorBaseAccessionNumber != null ? this.vectorBaseAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.vectorBaseDescription != null ? this.vectorBaseDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.vectorBaseAccessionNumber + ":" + this.vectorBaseDescription + ";";
    }

    @Override
    public VectorBaseAccessionNumber getVectorBaseAccessionNumber() {
        return this.vectorBaseAccessionNumber;
    }

    @Override
    public void setVectorBaseAccessionNumber(VectorBaseAccessionNumber vectorBaseAccessionNumber) {
        if (vectorBaseAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.vectorBaseAccessionNumber = vectorBaseAccessionNumber;
    }

    @Override
    public boolean hasVectorBaseAccessionNumber() {
        return !this.vectorBaseAccessionNumber.getValue().equals("");
    }

    @Override
    public VectorBaseDescription getVectorBaseDescription() {
        return this.vectorBaseDescription;
    }

    @Override
    public void setVectorBaseDescription(VectorBaseDescription vectorBaseDescription) {
        if (vectorBaseDescription == null) {
            throw new IllegalArgumentException();
        }
        this.vectorBaseDescription = vectorBaseDescription;
    }

    @Override
    public boolean hasVectorBaseDescription() {
        return !this.vectorBaseDescription.getValue().equals("");
    }
}

