/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.unipep;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.unipep.UniPep;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.unipep.UniPepAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.unipep.UniPepDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class UniPepImpl
extends DatabaseCrossReferenceImpl
implements UniPep,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.UNIPEP;
    private long id = 0L;
    private UniPepAccessionNumber uniPepAccessionNumber = DefaultXRefFactory.getInstance().buildUniPepAccessionNumber("");
    private UniPepDescription uniPepDescription = DefaultXRefFactory.getInstance().buildUniPepDescription("");

    public UniPepImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getUniPepAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public UniPepImpl(UniPepImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasUniPepAccessionNumber()) {
            this.setUniPepAccessionNumber(toCopy.getUniPepAccessionNumber());
        }
        if (toCopy.hasUniPepDescription()) {
            this.setUniPepDescription(toCopy.getUniPepDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof UniPepImpl)) {
            return false;
        }
        UniPepImpl myClass = (UniPepImpl)o;
        if (!this.uniPepAccessionNumber.equals(myClass.getUniPepAccessionNumber())) {
            return false;
        }
        return this.uniPepDescription.equals(myClass.getUniPepDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.uniPepAccessionNumber != null ? this.uniPepAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.uniPepDescription != null ? this.uniPepDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.uniPepAccessionNumber + ":" + this.uniPepDescription + ";";
    }

    @Override
    public UniPepAccessionNumber getUniPepAccessionNumber() {
        return this.uniPepAccessionNumber;
    }

    @Override
    public void setUniPepAccessionNumber(UniPepAccessionNumber uniPepAccessionNumber) {
        if (uniPepAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.uniPepAccessionNumber = uniPepAccessionNumber;
    }

    @Override
    public boolean hasUniPepAccessionNumber() {
        return !this.uniPepAccessionNumber.getValue().equals("");
    }

    @Override
    public UniPepDescription getUniPepDescription() {
        return this.uniPepDescription;
    }

    @Override
    public void setUniPepDescription(UniPepDescription uniPepDescription) {
        if (uniPepDescription == null) {
            throw new IllegalArgumentException();
        }
        this.uniPepDescription = uniPepDescription;
    }

    @Override
    public boolean hasUniPepDescription() {
        return !this.uniPepDescription.getValue().equals("");
    }
}

