/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.unigene;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.unigene.UniGene;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.unigene.UniGeneAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.unigene.UniGeneDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class UniGeneImpl
extends DatabaseCrossReferenceImpl
implements UniGene,
PersistentObject {
    private DatabaseType databaseType = DatabaseType.UNIGENE;
    private long id = 0L;
    private UniGeneAccessionNumber uniGeneAccessionNumber = DefaultXRefFactory.getInstance().buildUniGeneAccessionNumber("");
    private UniGeneDescription uniGeneDescription = DefaultXRefFactory.getInstance().buildUniGeneDescription("");

    public UniGeneImpl() {
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public UniGeneImpl(UniGeneImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasUniGeneAccessionNumber()) {
            this.setUniGeneAccessionNumber(toCopy.getUniGeneAccessionNumber());
        }
        if (toCopy.hasUniGeneDescription()) {
            this.setUniGeneDescription(toCopy.getUniGeneDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof UniGeneImpl)) {
            return false;
        }
        UniGeneImpl myClass = (UniGeneImpl)o;
        if (!this.uniGeneAccessionNumber.equals(myClass.getUniGeneAccessionNumber())) {
            return false;
        }
        return this.uniGeneDescription.equals(myClass.getUniGeneDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.uniGeneAccessionNumber != null ? this.uniGeneAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.uniGeneDescription != null ? this.uniGeneDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.uniGeneAccessionNumber + ":" + this.uniGeneDescription + ";";
    }

    @Override
    public UniGeneAccessionNumber getUniGeneAccessionNumber() {
        return this.uniGeneAccessionNumber;
    }

    @Override
    public void setUniGeneAccessionNumber(UniGeneAccessionNumber uniGeneAccessionNumber) {
        if (uniGeneAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.uniGeneAccessionNumber = uniGeneAccessionNumber;
    }

    @Override
    public boolean hasUniGeneAccessionNumber() {
        return !this.uniGeneAccessionNumber.getValue().equals("");
    }

    @Override
    public UniGeneDescription getUniGeneDescription() {
        return this.uniGeneDescription;
    }

    @Override
    public void setUniGeneDescription(UniGeneDescription uniGeneDescription) {
        if (uniGeneDescription == null) {
            throw new IllegalArgumentException();
        }
        this.uniGeneDescription = uniGeneDescription;
    }

    @Override
    public boolean hasUniGeneDescription() {
        return !this.uniGeneDescription.getValue().equals("");
    }
}

