/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.ucsc;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ucsc.Ucsc;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ucsc.UcscAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ucsc.UcscDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class UcscImpl
extends DatabaseCrossReferenceImpl
implements Ucsc,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.UCSC;
    private long id = 0L;
    private UcscAccessionNumber ucscAccessionNumber = DefaultXRefFactory.getInstance().buildUcscAccessionNumber("");
    private UcscDescription ucscDescription = DefaultXRefFactory.getInstance().buildUcscDescription("");

    public UcscImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getUcscAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public UcscImpl(UcscImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasUcscAccessionNumber()) {
            this.setUcscAccessionNumber(toCopy.getUcscAccessionNumber());
        }
        if (toCopy.hasUcscDescription()) {
            this.setUcscDescription(toCopy.getUcscDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof UcscImpl)) {
            return false;
        }
        UcscImpl myClass = (UcscImpl)o;
        if (!this.ucscAccessionNumber.equals(myClass.getUcscAccessionNumber())) {
            return false;
        }
        return this.ucscDescription.equals(myClass.getUcscDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.ucscAccessionNumber != null ? this.ucscAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.ucscDescription != null ? this.ucscDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.ucscAccessionNumber + ":" + this.ucscDescription + ";";
    }

    @Override
    public UcscAccessionNumber getUcscAccessionNumber() {
        return this.ucscAccessionNumber;
    }

    @Override
    public void setUcscAccessionNumber(UcscAccessionNumber ucscAccessionNumber) {
        if (ucscAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.ucscAccessionNumber = ucscAccessionNumber;
    }

    @Override
    public boolean hasUcscAccessionNumber() {
        return !this.ucscAccessionNumber.getValue().equals("");
    }

    @Override
    public UcscDescription getUcscDescription() {
        return this.ucscDescription;
    }

    @Override
    public void setUcscDescription(UcscDescription ucscDescription) {
        if (ucscDescription == null) {
            throw new IllegalArgumentException();
        }
        this.ucscDescription = ucscDescription;
    }

    @Override
    public boolean hasUcscDescription() {
        return !this.ucscDescription.getValue().equals("");
    }
}

