/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.tuberculist;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.tuberculist.TubercuList;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.tuberculist.TubercuListAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.tuberculist.TubercuListDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class TubercuListImpl
extends DatabaseCrossReferenceImpl
implements TubercuList,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.TUBERCULIST;
    private long id = 0L;
    private TubercuListAccessionNumber tubercuListAccessionNumber = DefaultXRefFactory.getInstance().buildTubercuListAccessionNumber("");
    private TubercuListDescription tubercuListDescription = DefaultXRefFactory.getInstance().buildTubercuListDescription("");

    public TubercuListImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getTubercuListAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public TubercuListImpl(TubercuListImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasTubercuListAccessionNumber()) {
            this.setTubercuListAccessionNumber(toCopy.getTubercuListAccessionNumber());
        }
        if (toCopy.hasTubercuListDescription()) {
            this.setTubercuListDescription(toCopy.getTubercuListDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof TubercuListImpl)) {
            return false;
        }
        TubercuListImpl myClass = (TubercuListImpl)o;
        if (!this.tubercuListAccessionNumber.equals(myClass.getTubercuListAccessionNumber())) {
            return false;
        }
        return this.tubercuListDescription.equals(myClass.getTubercuListDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.tubercuListAccessionNumber != null ? this.tubercuListAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.tubercuListDescription != null ? this.tubercuListDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.tubercuListAccessionNumber + ":" + this.tubercuListDescription + ";";
    }

    @Override
    public TubercuListAccessionNumber getTubercuListAccessionNumber() {
        return this.tubercuListAccessionNumber;
    }

    @Override
    public void setTubercuListAccessionNumber(TubercuListAccessionNumber tubercuListAccessionNumber) {
        if (tubercuListAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.tubercuListAccessionNumber = tubercuListAccessionNumber;
    }

    @Override
    public boolean hasTubercuListAccessionNumber() {
        return !this.tubercuListAccessionNumber.getValue().equals("");
    }

    @Override
    public TubercuListDescription getTubercuListDescription() {
        return this.tubercuListDescription;
    }

    @Override
    public void setTubercuListDescription(TubercuListDescription tubercuListDescription) {
        if (tubercuListDescription == null) {
            throw new IllegalArgumentException();
        }
        this.tubercuListDescription = tubercuListDescription;
    }

    @Override
    public boolean hasTubercuListDescription() {
        return !this.tubercuListDescription.getValue().equals("");
    }
}

