/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.transfac;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.transfac.Transfac;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.transfac.TransfacAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.transfac.TransfacDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class TransfacImpl
extends DatabaseCrossReferenceImpl
implements Transfac,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.TRANSFAC;
    private long id = 0L;
    private TransfacAccessionNumber transfacAccessionNumber = DefaultXRefFactory.getInstance().buildTransfacAccessionNumber("");
    private TransfacDescription transfacDescription = DefaultXRefFactory.getInstance().buildTransfacDescription("");

    public TransfacImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getTransfacAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public TransfacImpl(TransfacImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasTransfacAccessionNumber()) {
            this.setTransfacAccessionNumber(toCopy.getTransfacAccessionNumber());
        }
        if (toCopy.hasTransfacDescription()) {
            this.setTransfacDescription(toCopy.getTransfacDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransfacImpl)) {
            return false;
        }
        TransfacImpl myClass = (TransfacImpl)o;
        if (!this.transfacAccessionNumber.equals(myClass.getTransfacAccessionNumber())) {
            return false;
        }
        return this.transfacDescription.equals(myClass.getTransfacDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.transfacAccessionNumber != null ? this.transfacAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.transfacDescription != null ? this.transfacDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.transfacAccessionNumber + ":" + this.transfacDescription + ";";
    }

    @Override
    public TransfacAccessionNumber getTransfacAccessionNumber() {
        return this.transfacAccessionNumber;
    }

    @Override
    public void setTransfacAccessionNumber(TransfacAccessionNumber transfacAccessionNumber) {
        if (transfacAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.transfacAccessionNumber = transfacAccessionNumber;
    }

    @Override
    public boolean hasTransfacAccessionNumber() {
        return !this.transfacAccessionNumber.getValue().equals("");
    }

    @Override
    public TransfacDescription getTransfacDescription() {
        return this.transfacDescription;
    }

    @Override
    public void setTransfacDescription(TransfacDescription transfacDescription) {
        if (transfacDescription == null) {
            throw new IllegalArgumentException();
        }
        this.transfacDescription = transfacDescription;
    }

    @Override
    public boolean hasTransfacDescription() {
        return !this.transfacDescription.getValue().equals("");
    }
}

