/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.tigr;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.tigr.Tigr;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.tigr.TigrAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.tigr.TigrDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class TigrImpl
extends DatabaseCrossReferenceImpl
implements Tigr,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.TIGR;
    private long id = 0L;
    private TigrAccessionNumber tigrAccessionNumber = DefaultXRefFactory.getInstance().buildTigrAccessionNumber("");
    private TigrDescription tigrDescription = DefaultXRefFactory.getInstance().buildTigrDescription("");

    public TigrImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getTigrAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public TigrImpl(TigrImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasTigrAccessionNumber()) {
            this.setTigrAccessionNumber(toCopy.getTigrAccessionNumber());
        }
        if (toCopy.hasTigrDescription()) {
            this.setTigrDescription(toCopy.getTigrDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof TigrImpl)) {
            return false;
        }
        TigrImpl myClass = (TigrImpl)o;
        if (!this.tigrAccessionNumber.equals(myClass.getTigrAccessionNumber())) {
            return false;
        }
        return this.tigrDescription.equals(myClass.getTigrDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.tigrAccessionNumber != null ? this.tigrAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.tigrDescription != null ? this.tigrDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.tigrAccessionNumber + ":" + this.tigrDescription + ";";
    }

    @Override
    public TigrAccessionNumber getTigrAccessionNumber() {
        return this.tigrAccessionNumber;
    }

    @Override
    public void setTigrAccessionNumber(TigrAccessionNumber tigrAccessionNumber) {
        if (tigrAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.tigrAccessionNumber = tigrAccessionNumber;
    }

    @Override
    public boolean hasTigrAccessionNumber() {
        return !this.tigrAccessionNumber.getValue().equals("");
    }

    @Override
    public TigrDescription getTigrDescription() {
        return this.tigrDescription;
    }

    @Override
    public void setTigrDescription(TigrDescription tigrDescription) {
        if (tigrDescription == null) {
            throw new IllegalArgumentException();
        }
        this.tigrDescription = tigrDescription;
    }

    @Override
    public boolean hasTigrDescription() {
        return !this.tigrDescription.getValue().equals("");
    }
}

