/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.tcdb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.tcdb.Tcdb;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.tcdb.TcdbAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.tcdb.TcdbDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class TcdbImpl
extends DatabaseCrossReferenceImpl
implements Tcdb,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.TCDB;
    private long id = 0L;
    private TcdbAccessionNumber tcdbAccessionNumber = DefaultXRefFactory.getInstance().buildTcdbAccessionNumber("");
    private TcdbDescription tcdbDescription = DefaultXRefFactory.getInstance().buildTcdbDescription("");

    public TcdbImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getTcdbAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public TcdbImpl(TcdbImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasTcdbAccessionNumber()) {
            this.setTcdbAccessionNumber(toCopy.getTcdbAccessionNumber());
        }
        if (toCopy.hasTcdbDescription()) {
            this.setTcdbDescription(toCopy.getTcdbDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof TcdbImpl)) {
            return false;
        }
        TcdbImpl myClass = (TcdbImpl)o;
        if (!this.tcdbAccessionNumber.equals(myClass.getTcdbAccessionNumber())) {
            return false;
        }
        return this.tcdbDescription.equals(myClass.getTcdbDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.tcdbAccessionNumber != null ? this.tcdbAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.tcdbDescription != null ? this.tcdbDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.tcdbAccessionNumber + ":" + this.tcdbDescription + ";";
    }

    @Override
    public TcdbAccessionNumber getTcdbAccessionNumber() {
        return this.tcdbAccessionNumber;
    }

    @Override
    public void setTcdbAccessionNumber(TcdbAccessionNumber tcdbAccessionNumber) {
        if (tcdbAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.tcdbAccessionNumber = tcdbAccessionNumber;
    }

    @Override
    public boolean hasTcdbAccessionNumber() {
        return !this.tcdbAccessionNumber.getValue().equals("");
    }

    @Override
    public TcdbDescription getTcdbDescription() {
        return this.tcdbDescription;
    }

    @Override
    public void setTcdbDescription(TcdbDescription tcdbDescription) {
        if (tcdbDescription == null) {
            throw new IllegalArgumentException();
        }
        this.tcdbDescription = tcdbDescription;
    }

    @Override
    public boolean hasTcdbDescription() {
        return !this.tcdbDescription.getValue().equals("");
    }
}

