/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.tair;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.tair.Tair;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.tair.TairAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.tair.TairDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class TairImpl
extends DatabaseCrossReferenceImpl
implements Tair,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.TAIR;
    private long id = 0L;
    private TairAccessionNumber tairAccessionNumber = DefaultXRefFactory.getInstance().buildTairAccessionNumber("");
    private TairDescription tairDescription = DefaultXRefFactory.getInstance().buildTairDescription("");

    public TairImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getTairAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public TairImpl(TairImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasTairAccessionNumber()) {
            this.setTairAccessionNumber(toCopy.getTairAccessionNumber());
        }
        if (toCopy.hasTairDescription()) {
            this.setTairDescription(toCopy.getTairDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof TairImpl)) {
            return false;
        }
        TairImpl myClass = (TairImpl)o;
        if (!this.tairAccessionNumber.equals(myClass.getTairAccessionNumber())) {
            return false;
        }
        return this.tairDescription.equals(myClass.getTairDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.tairAccessionNumber != null ? this.tairAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.tairDescription != null ? this.tairDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.tairAccessionNumber + ":" + this.tairDescription + ";";
    }

    @Override
    public TairAccessionNumber getTairAccessionNumber() {
        return this.tairAccessionNumber;
    }

    @Override
    public void setTairAccessionNumber(TairAccessionNumber tairAccessionNumber) {
        if (tairAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.tairAccessionNumber = tairAccessionNumber;
    }

    @Override
    public boolean hasTairAccessionNumber() {
        return !this.tairAccessionNumber.getValue().equals("");
    }

    @Override
    public TairDescription getTairDescription() {
        return this.tairDescription;
    }

    @Override
    public void setTairDescription(TairDescription tairDescription) {
        if (tairDescription == null) {
            throw new IllegalArgumentException();
        }
        this.tairDescription = tairDescription;
    }

    @Override
    public boolean hasTairDescription() {
        return !this.tairDescription.getValue().equals("");
    }
}

