/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.supfam;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.supfam.SUPFAM;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.supfam.SuperFamilyDomainName;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.supfam.SuperFamilyIdentifier;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.supfam.SuperFamilyMatchStatus;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class SUPFAMImpl
extends DatabaseCrossReferenceImpl
implements SUPFAM,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.SUPFAM;
    private long id = 0L;
    private SuperFamilyIdentifier superFamilyIdentifier = DefaultXRefFactory.getInstance().buildSuperFamilyIdentifier("");
    private SuperFamilyDomainName superFamilyDomainName = DefaultXRefFactory.getInstance().buildSuperFamilyDomainName("");
    private SuperFamilyMatchStatus superFamilyMatchStatus = DefaultXRefFactory.getInstance().buildSuperFamilyMatchStatus("");

    public SUPFAMImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getSuperFamilyIdentifier().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public SUPFAMImpl(SUPFAMImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasSuperFamilyIdentifier()) {
            this.setSuperFamilyIdentifier(toCopy.getSuperFamilyIdentifier());
        }
        if (toCopy.hasSuperFamilyDomainName()) {
            this.setSuperFamilyDomainName(toCopy.getSuperFamilyDomainName());
        }
        if (toCopy.hasSuperFamilyMatchStatus()) {
            this.setSuperFamilyMatchStatus(toCopy.getSuperFamilyMatchStatus());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof SUPFAMImpl)) {
            return false;
        }
        SUPFAMImpl myClass = (SUPFAMImpl)o;
        if (!this.superFamilyIdentifier.equals(myClass.getSuperFamilyIdentifier())) {
            return false;
        }
        if (!this.superFamilyDomainName.equals(myClass.getSuperFamilyDomainName())) {
            return false;
        }
        return this.superFamilyMatchStatus.equals(myClass.getSuperFamilyMatchStatus());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.superFamilyIdentifier != null ? this.superFamilyIdentifier.hashCode() : 0);
        result = 29 * result + (this.superFamilyDomainName != null ? this.superFamilyDomainName.hashCode() : 0);
        result = 29 * result + (this.superFamilyMatchStatus != null ? this.superFamilyMatchStatus.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.superFamilyIdentifier + ":" + this.superFamilyDomainName + ":" + this.superFamilyMatchStatus + ";";
    }

    @Override
    public SuperFamilyIdentifier getSuperFamilyIdentifier() {
        return this.superFamilyIdentifier;
    }

    @Override
    public void setSuperFamilyIdentifier(SuperFamilyIdentifier superFamilyIdentifier) {
        if (superFamilyIdentifier == null) {
            throw new IllegalArgumentException();
        }
        this.superFamilyIdentifier = superFamilyIdentifier;
    }

    @Override
    public boolean hasSuperFamilyIdentifier() {
        return !this.superFamilyIdentifier.getValue().equals("");
    }

    @Override
    public SuperFamilyDomainName getSuperFamilyDomainName() {
        return this.superFamilyDomainName;
    }

    @Override
    public void setSuperFamilyDomainName(SuperFamilyDomainName superFamilyDomainName) {
        if (superFamilyDomainName == null) {
            throw new IllegalArgumentException();
        }
        this.superFamilyDomainName = superFamilyDomainName;
    }

    @Override
    public boolean hasSuperFamilyDomainName() {
        return !this.superFamilyDomainName.getValue().equals("");
    }

    @Override
    public SuperFamilyMatchStatus getSuperFamilyMatchStatus() {
        return this.superFamilyMatchStatus;
    }

    @Override
    public void setSuperFamilyMatchStatus(SuperFamilyMatchStatus superFamilyMatchStatus) {
        if (superFamilyMatchStatus == null) {
            throw new IllegalArgumentException();
        }
        this.superFamilyMatchStatus = superFamilyMatchStatus;
    }

    @Override
    public boolean hasSuperFamilyMatchStatus() {
        return !this.superFamilyMatchStatus.getValue().equals("");
    }
}

