/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.subtilist;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.subtilist.SubtiList;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.subtilist.SubtiListAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.subtilist.SubtiListDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class SubtiListImpl
extends DatabaseCrossReferenceImpl
implements SubtiList,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.SUBTILIST;
    private long id = 0L;
    private SubtiListAccessionNumber subtiListAccessionNumber = DefaultXRefFactory.getInstance().buildSubtiListAccessionNumber("");
    private SubtiListDescription subtiListDescription = DefaultXRefFactory.getInstance().buildSubtiListDescription("");

    public SubtiListImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getSubtiListAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public SubtiListImpl(SubtiListImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasSubtiListAccessionNumber()) {
            this.setSubtiListAccessionNumber(toCopy.getSubtiListAccessionNumber());
        }
        if (toCopy.hasSubtiListDescription()) {
            this.setSubtiListDescription(toCopy.getSubtiListDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubtiListImpl)) {
            return false;
        }
        SubtiListImpl myClass = (SubtiListImpl)o;
        if (!this.subtiListAccessionNumber.equals(myClass.getSubtiListAccessionNumber())) {
            return false;
        }
        return this.subtiListDescription.equals(myClass.getSubtiListDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.subtiListAccessionNumber != null ? this.subtiListAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.subtiListDescription != null ? this.subtiListDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.subtiListAccessionNumber + ":" + this.subtiListDescription + ";";
    }

    @Override
    public SubtiListAccessionNumber getSubtiListAccessionNumber() {
        return this.subtiListAccessionNumber;
    }

    @Override
    public void setSubtiListAccessionNumber(SubtiListAccessionNumber subtiListAccessionNumber) {
        if (subtiListAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.subtiListAccessionNumber = subtiListAccessionNumber;
    }

    @Override
    public boolean hasSubtiListAccessionNumber() {
        return !this.subtiListAccessionNumber.getValue().equals("");
    }

    @Override
    public SubtiListDescription getSubtiListDescription() {
        return this.subtiListDescription;
    }

    @Override
    public void setSubtiListDescription(SubtiListDescription subtiListDescription) {
        if (subtiListDescription == null) {
            throw new IllegalArgumentException();
        }
        this.subtiListDescription = subtiListDescription;
    }

    @Override
    public boolean hasSubtiListDescription() {
        return !this.subtiListDescription.getValue().equals("");
    }
}

